# 2-EWLnet

We test popular geometric GNNs for separation capability. We show that architectures simulating the 1-EWL test are incomplete, i.e. do not distinguish among all point clouds, and architectures with high-order correlations are able to. Our provably complete 2-EWL can distinguish these difficult counterexamples with dimensionality matching our theoretical minimum. 

This code reproduces the empirical evaluation in "Complete Neural Networks for Euclidean Graphs".

## Experiments

The `/experiments` directory contains notebooks with synthetic experiments to highlight practical challenges in building powerful geometric GNNs:
- `incompleteness.ipynb`: Counterexamples from [Pozdnyakov et al.](https://journals.aps.org/prl/abstract/10.1103/PhysRevLett.125.166001).



## Installation

```bash
# Create new conda environment
conda create --prefix ./env python=3.8
conda activate ./env

# Install PyTorch (Check CUDA version for GPU!)
#
# Option 1: CPU
#conda install pytorch==1.12.0 -c pytorch
#
# Option 2: GPU, CUDA 11.3
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.3 -c pytorch

# Install dependencies
conda install matplotlib pandas networkx
conda install jupyterlab -c conda-forge
pip install e3nn==0.4.4 ipdb ase

# Install PyG (Check CPU/GPU/MacOS)
#
# Option 1: CPU, MacOS
#pip install torch-scatter torch-sparse torch-cluster torch-spline-conv -f https://data.pyg.org/whl/torch-1.12.0+cpu.html 
#pip install torch-geometric
#pip install geotorch
#
# Option 2: GPU, CUDA 11.3
pip install torch-scatter torch-sparse torch-cluster torch-spline-conv -f https://data.pyg.org/whl/torch-1.12.1+cu113.html
pip install torch-geometric
pip install geotorch
#
# Option 3: CPU/GPU, but may not work on MacOS
conda install pyg -c pyg
pip install geotorch
```


## Directory Structure and Usage

```
.
├── README.md
├── experiments                         # Synthetic experiments
│   ├── incompleteness.ipynb            # Experiment on counterexamples from Pozdnyakov et al.
| 
└── src                                 # Geometric GNN models library
    ├── models.py                       # Models built using layers
    ├── gvp_layers.py                   # Layers for GVP-GNN
    ├── egnn_layers.py                  # Layers for E(n) Equivariant GNN
    ├── tfn_layers.py                   # Layers for Tensor Field Networks
    ├── modules                         # Layers for MACE
    └── utils                           # Helper functions for training, plotting, etc.
```

The user need only consider the notebook incompleteness.ipynb, and running the cells (can be done with shortcut Shift+Enter).

Go to the parent directory and run 

'''
jupyter lab --no-browser --ip=$(hostname -I) --port-retries=100
'''

## Credit

We modified the original code from On the Expressive Power of Geometric Graph Neural Networks by Joshi, Chaitanya K. and Bodnar, Cristian and  Mathis, Simon V. and Cohen, Taco and Liò, Pietro.