<div align="center">

# Q-learning with Adjoint Matching

</div>

Installation: `pip install -r requirements.txt`

Example scripts for `cube-triple`:

```bash

# QAM
MUJOCO_GL=egl python main.py --run_group=reproduce-minimal --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=10.0,tau=10.0" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5

# FBRAC
MUJOCO_GL=egl python main.py --run_group=reproduce-minimal --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=0.01 --tags="FBRAC,alpha=0.01" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5

# FQL
MUJOCO_GL=egl python main.py --run_group=reproduce-minimal --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=100.0 --tags="FQL,alpha=100.0" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5

# CGQL
MUJOCO_GL=egl python main.py --run_group=reproduce-minimal --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5

# FAWAC
MUJOCO_GL=egl python main.py --run_group=reproduce-minimal --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5

# DSRL
MUJOCO_GL=egl python main.py --run_group=reproduce-minimal --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=1.0 --tags="DSRL,ns=1.0" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5

# FEdit
MUJOCO_GL=egl python main.py --run_group=reproduce-minimal --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5

# IFQL
MUJOCO_GL=egl python main.py --run_group=reproduce-minimal --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5
```

## How do I obtain the 100M dataset for cube-quadruple?
Please visit the official OGBench repository for information on how to generate these large datasets.
