#!/bin/bash

TASK_ID=$((SLURM_ARRAY_TASK_ID-1))
PARALLEL_N=1
JOB_N=8

COM_ID_S=$((TASK_ID * PARALLEL_N + 1))

declare -a commands=(
  [1]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimal_debug --offline_steps=100 --eval_episodes=1 --eval_interval=5 --start_training=50 --online_steps=100 --log_interval=25 --agent=agents/fbrac.py --agent.alpha=0.01 --tags="FBRAC,alpha=0.01" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [2]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimal_debug --offline_steps=100 --eval_episodes=1 --eval_interval=5 --start_training=50 --online_steps=100 --log_interval=25 --agent=agents/cgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [3]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimal_debug --offline_steps=100 --eval_episodes=1 --eval_interval=5 --start_training=50 --online_steps=100 --log_interval=25 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=10.0,tau=10.0" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [4]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimal_debug --offline_steps=100 --eval_episodes=1 --eval_interval=5 --start_training=50 --online_steps=100 --log_interval=25 --agent=agents/fql.py --agent.alpha=100.0 --tags="FQL,alpha=100.0" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [5]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimal_debug --offline_steps=100 --eval_episodes=1 --eval_interval=5 --start_training=50 --online_steps=100 --log_interval=25 --agent=agents/dsrl.py --agent.noise_scale=1.0 --tags="DSRL,ns=1.0" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [6]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimal_debug --offline_steps=100 --eval_episodes=1 --eval_interval=5 --start_training=50 --online_steps=100 --log_interval=25 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [7]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimal_debug --offline_steps=100 --eval_episodes=1 --eval_interval=5 --start_training=50 --online_steps=100 --log_interval=25 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [8]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimal_debug --offline_steps=100 --eval_episodes=1 --eval_interval=5 --start_training=50 --online_steps=100 --log_interval=25 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=1 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
)

parallel --delay 5s --linebuffer -j 1 {1} ::: "${commands[@]:$COM_ID_S:$PARALLEL_N}"
        