#!/bin/bash

TASK_ID=$((SLURM_ARRAY_TASK_ID-1))
PARALLEL_N=1
JOB_N=160

COM_ID_S=$((TASK_ID * PARALLEL_N + 1))

declare -a commands=(
  [1]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=0.1 --tags="FBRAC,alpha=0.1" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [2]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [3]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=1.0 --tags="QAM,ccg=10.0,tau=1.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [4]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=300.0 --tags="FQL,alpha=300.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [5]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.5 --tags="DSRL,ns=0.5" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [6]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [7]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [8]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [9]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=0.01 --tags="FBRAC,alpha=0.01" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [10]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [11]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=10.0,tau=10.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [12]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=100.0 --tags="FQL,alpha=100.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [13]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=1.0 --tags="DSRL,ns=1.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [14]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [15]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [16]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [17]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=1.0 --tags="FBRAC,alpha=1.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [18]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [19]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=3.0 --tags="QAM,ccg=10.0,tau=3.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [20]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=30.0 --tags="FQL,alpha=30.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [21]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=1.25 --tags="DSRL,ns=1.25" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [22]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [23]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [24]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [25]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=10.0 --tags="FBRAC,alpha=10.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [26]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [27]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=100.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=100.0,tau=10.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [28]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=10.0 --tags="FQL,alpha=10.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [29]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.25 --tags="DSRL,ns=0.25" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [30]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [31]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [32]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [33]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=10.0 --tags="FBRAC,alpha=10.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [34]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [35]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=100.0 --agent.target_actor=True --agent.tau=3.0 --tags="QAM,ccg=100.0,tau=3.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [36]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=10.0 --tags="FQL,alpha=10.0" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [37]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.25 --tags="DSRL,ns=0.25" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [38]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [39]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [40]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=10001 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [41]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=0.1 --tags="FBRAC,alpha=0.1" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [42]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [43]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=1.0 --tags="QAM,ccg=10.0,tau=1.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [44]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=300.0 --tags="FQL,alpha=300.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [45]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.5 --tags="DSRL,ns=0.5" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [46]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [47]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [48]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [49]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=0.01 --tags="FBRAC,alpha=0.01" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [50]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [51]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=10.0,tau=10.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [52]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=100.0 --tags="FQL,alpha=100.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [53]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=1.0 --tags="DSRL,ns=1.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [54]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [55]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [56]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [57]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=1.0 --tags="FBRAC,alpha=1.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [58]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [59]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=3.0 --tags="QAM,ccg=10.0,tau=3.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [60]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=30.0 --tags="FQL,alpha=30.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [61]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=1.25 --tags="DSRL,ns=1.25" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [62]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [63]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [64]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [65]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=10.0 --tags="FBRAC,alpha=10.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [66]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [67]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=100.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=100.0,tau=10.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [68]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=10.0 --tags="FQL,alpha=10.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [69]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.25 --tags="DSRL,ns=0.25" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [70]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [71]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [72]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [73]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=10.0 --tags="FBRAC,alpha=10.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [74]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [75]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=100.0 --agent.target_actor=True --agent.tau=3.0 --tags="QAM,ccg=100.0,tau=3.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [76]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=10.0 --tags="FQL,alpha=10.0" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [77]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.25 --tags="DSRL,ns=0.25" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [78]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [79]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [80]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=20002 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [81]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=0.1 --tags="FBRAC,alpha=0.1" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [82]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [83]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=1.0 --tags="QAM,ccg=10.0,tau=1.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [84]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=300.0 --tags="FQL,alpha=300.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [85]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.5 --tags="DSRL,ns=0.5" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [86]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [87]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [88]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [89]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=0.01 --tags="FBRAC,alpha=0.01" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [90]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [91]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=10.0,tau=10.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [92]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=100.0 --tags="FQL,alpha=100.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [93]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=1.0 --tags="DSRL,ns=1.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [94]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [95]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [96]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [97]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=1.0 --tags="FBRAC,alpha=1.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [98]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [99]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=3.0 --tags="QAM,ccg=10.0,tau=3.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [100]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=30.0 --tags="FQL,alpha=30.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [101]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=1.25 --tags="DSRL,ns=1.25" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [102]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [103]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [104]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [105]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=10.0 --tags="FBRAC,alpha=10.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [106]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [107]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=100.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=100.0,tau=10.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [108]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=10.0 --tags="FQL,alpha=10.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [109]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.25 --tags="DSRL,ns=0.25" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [110]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [111]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [112]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [113]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=10.0 --tags="FBRAC,alpha=10.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [114]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [115]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=100.0 --agent.target_actor=True --agent.tau=3.0 --tags="QAM,ccg=100.0,tau=3.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [116]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=10.0 --tags="FQL,alpha=10.0" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [117]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.25 --tags="DSRL,ns=0.25" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [118]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [119]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [120]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=30003 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [121]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=0.1 --tags="FBRAC,alpha=0.1" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [122]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [123]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=1.0 --tags="QAM,ccg=10.0,tau=1.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [124]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=300.0 --tags="FQL,alpha=300.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [125]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.5 --tags="DSRL,ns=0.5" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [126]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [127]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [128]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-double-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [129]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=0.01 --tags="FBRAC,alpha=0.01" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [130]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [131]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=10.0,tau=10.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [132]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=100.0 --tags="FQL,alpha=100.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [133]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=1.0 --tags="DSRL,ns=1.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [134]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [135]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [136]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-triple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [137]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=1.0 --tags="FBRAC,alpha=1.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [138]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [139]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=10.0 --agent.target_actor=True --agent.tau=3.0 --tags="QAM,ccg=10.0,tau=3.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [140]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=30.0 --tags="FQL,alpha=30.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [141]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=1.25 --tags="DSRL,ns=1.25" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [142]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.5 --tags="FEDIT,edit_scale=0.5" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [143]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [144]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=cube-quadruple-play-singletask-v0 --horizon_length=5 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5 --ogbench_dataset_dir=[]/cube-quadruple-play-100m-v0/'
  [145]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=10.0 --tags="FBRAC,alpha=10.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [146]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [147]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=100.0 --agent.target_actor=True --agent.tau=10.0 --tags="QAM,ccg=100.0,tau=10.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [148]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=10.0 --tags="FQL,alpha=10.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [149]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.25 --tags="DSRL,ns=0.25" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [150]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [151]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [152]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-large-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.99 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [153]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fbrac.py --agent.alpha=10.0 --tags="FBRAC,alpha=10.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [154]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/cfgql.py --agent.simple=True --agent.target_guidance=True --agent.guidance_coef=0.1 --agent.noisy_coef=0.0 --tags="CGQL,gc=0.1" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [155]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/qam.py --agent.clip_adj=True --agent.clip_critic_grad=100.0 --agent.target_actor=True --agent.tau=3.0 --tags="QAM,ccg=100.0,tau=3.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [156]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fql.py --agent.alpha=10.0 --tags="FQL,alpha=10.0" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [157]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/dsrl.py --agent.noise_scale=0.25 --tags="DSRL,ns=0.25" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [158]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fedit.py --agent.edit_scale=0.25 --tags="FEDIT,edit_scale=0.25" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [159]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/fawac.py --agent.inv_temp=10 --tags="FAWAC,tau=10" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
  [160]='MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --online_steps=1000000 --save_interval=100000 --agent=agents/ifql.py --agent.num_samples=32 --tags="IFQL,N=32" --seed=40004 --utd_ratio=1 --agent.num_qs=10 --env_name=antmaze-giant-navigate-singletask-v0 --horizon_length=1 --agent.discount=0.999 --agent.action_chunking=True --agent.actor_hidden_dims="(512, 512, 512, 512)" --agent.value_hidden_dims="(512, 512, 512, 512)" --agent.batch_size=256 --agent.best_of_n=1 --agent.rho=0.5'
)

parallel --delay 5s --linebuffer -j 1 {1} ::: "${commands[@]:$COM_ID_S:$PARALLEL_N}"
        