# Supplementary materials
This folder contains the code necessary to reproduce the results from the paper "Multi-layer Stack Ensembles for Time Series Forecasting" (under review at AutoML Conference 2025).

## Installation
Install the package using `pip`
```bash
pip install -e .
```

## Contents
- `artifacts/` - saved base (L1) model predictions that can be used to train the L2 and L3 models.
- `datasets/` - code to download and preprocess the LOTSA datasets
- `results/` - raw results for the experiments in CSV format.
- `notebooks/` - Jupyter notebooks that allow reproducing individual experiments
  - `train_l1.ipynb` - Train base models and save the out-of-fold predictions to `artifacts/`.
  - `train_stacker.ipynb` - Train L2 and L3 stacker models on the stored out-of-fold predictions.
  - `aggregate_results.ipynb` - Code to generate the tables and figures from the paper.
- `src/` - source code. Contains the implementations of stacker models and the logic for aggregating the results.
