#!/bin/bash

#cd ../..

# custom config
DATA="/mnt/hdd/DATA"
TRAINER=ZeroshotCLIP
# DATASET=$1
CFG=vit_b16_ep50_bs4  # rn50, rn101, vit_b32 or vit_b16
# sub=$2
# SEED=$3
DEVICE=$1
for DATASET in caltech101 dtd eurosat fgvc_aircraft food101 imagenet oxford_flowers oxford_pets stanford_cars sun397 ucf101
do
    for sub in base new1 new2 new3 new4 new5 new_ratio1 new_ratio2 new_ratio3 new_ratio4 new_ratio5
    do
        for SEED in 1 2 3
        do
            python train.py \
            --root ${DATA} \
            --trainer ${TRAINER} \
            --seed ${SEED} \
            --dataset-config-file configs/datasets/${DATASET}.yaml \
            --config-file configs/trainers/CoOp/${CFG}.yaml \
            --output-dir output/${sub}/${TRAINER}/${CFG}/${DATASET}/${SEED} \
            --eval-only\
            DATASET.SUBSAMPLE_CLASSES ${sub}
        done
    done
done