#!/bin/bash

#cd ../..

# custom config
#DATA=/hub_data2/intern/data/
DATA="/mnt/hdd/DATA"
TRAINER=RPO

# DATASET=$1
# SEED=$2
GPU=$1

CFG=main_K24_ep50_batch4

SHOTS=16
LOADEP=50
# SUB=$7

for DATASET in caltech101 dtd eurosat fgvc_aircraft food101 imagenet oxford_flowers oxford_pets stanford_cars sun397 ucf101
do
    for SUB in new1 new2 new3 new4 new5 new_ratio1 new_ratio2 new_ratio3 new_ratio4 new_ratio5
    do
        for SEED in 1 2 3
        do
            COMMON_DIR=${DATASET}/shots_${SHOTS}/${TRAINER}/${CFG}/seed${SEED}
            MODEL_DIR=output/rpo/base2new/train_base/${COMMON_DIR}
            DIR=output/rpo/base2new/test_${SUB}/${COMMON_DIR}

            #if [ -d "$DIR" ]; then
            #    echo "Oops! The results exist at ${DIR} (so skip this job)"
            #else
            CUDA_VISIBLE_DEVICES=${GPU} python train.py \
            --root ${DATA} \
            --seed ${SEED} \
            --trainer ${TRAINER} \
            --dataset-config-file configs/datasets/${DATASET}.yaml \
            --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
            --output-dir ${DIR} \
            --model-dir ${MODEL_DIR} \
            --load-epoch ${LOADEP} \
            --eval-only \
            DATASET.NUM_SHOTS ${SHOTS} \
            DATASET.SUBSAMPLE_CLASSES ${SUB}
            #fi
        done
    done
done