#!/usr/bin/env bash
DATALIST=(cifar10)
BATCHSIZE=(128)
EPOCH=120
MODEL=resnet20
CHECKPOINTS=ckps
R=.pth.tar
DR=10
GPUS=(0 1 3 4)
ALGNAME=(ACCSCCMA FastDRO PDSGD SCCMA)
LAMDA1=(50)
WLR=(0.5 0.1 0.1 0.7)
PLR=(1e-4 5e-5 5e-4)
IMRATIO=(0.02 0.2)
RHO=(0.01 0.05 0.1 1)
BETA=(0.6)
CLASSTAU=(0.05 0.1 0.15)
#current GPU:11

for((wlr=1; wlr<2; wlr++)); do
{
for((agm=1; agm<2; agm++)); do
{
for((rpt=0; rpt<4; rpt++)); do
{
for((da=0; da<1; da++)); do
{
for((r=0; r<4; r++)); do
{
for((plr=0; plr<1; plr++)); do
{
for((lbd=0; lbd<1; lbd++)); do
{
for((b=0; b<1; b++)); do
{
for((ctu=0; ctu<1; ctu++)); do
{
    python3 -W ignore main.py \
            --dataset ${DATALIST[$da]} \
            --model $MODEL \
            --saveFolder ${DATALIST[$da]}/${ALGNAME[$agm]}/Wm_${ALGNAME[$agm]}_wlr_${WLR[$agm]}_rho_${RHO[$r]}_beta_${BETA[$b]}_plr_${PLR[$plr]}_lambda1_${LAMDA1[$lbd]}_batch_${BATCHSIZE}_epochs_${EPOCH}_model_${MODEL}_DR_${DR}_Repeats_${rpt} \
            --res_filename ${DATALIST[$da]}_${ALGNAME[$agm]}_wlr_${WLR[$agm]}_rho_${RHO[$r]}_beta_${BETA[$b]}_plr_${PLR[$plr]}_lambda0_${LAMDA0[$lbd]}_batch_${BATCHSIZE}_epochs_${EPOCH}_model_${MODEL}_DR_${DR}_Repeats_${rpt}_class_tau_${CLASSTAU[$ctu]}  \
            --epochs ${EPOCH} \
            --batch-size ${BATCHSIZE} \
            --gpus 0 \
            --lr ${WLR[$wlr]} \
            --restart_init_loop 1 \
            --lamda1 ${LAMDA1[$lbd]} \
            --epochs ${EPOCH} \
            --alg ${ALGNAME[$agm]} \
            --momentum 0.9 \
            --im_ratio ${IMRATIO[$da]} \
            --DR ${DR} \
            --sampleType uniform \
            --plr ${PLR[$plr]} \
            --rho ${RHO[$r]} \
            --beta ${BETA[$b]}\
            --class_tau ${CLASSTAU[$ctu]} \
            --lrlambda 0.00001 \
            --lamda0 1e-3 \
            --random_seed ${rpt} \
            --print_freq 50
}
done
}
done
}
done
}
done
}
done
}
done
}&
done
}
done
}
done



 #  --pretrained True \
 #  --frozen_aside_linear True \

# python3 fastdromain.py --algorithm batch --dataset imagenet --data_dir /home/qiuzh/imagenet --epochs 30 --momentum 0.9 --lr_schedule constant --averaging constant_3.0 --wd 1e-3 --geometry chi-square --size 1.0 --batch_size 500 --lr 1e-2 --output_dir ../output-dir
