# Environment Configuration

We recommend to install the environment through conda and pip. You should make a new environment with python>=3.9, for example:

```
conda create -n gpt_prompt python=3.9
```

Next, you can download pytorch from official site, for example:

```
conda install pytorch torchvision torchaudio cudatoolkit=11.3 -c pytorch
```

Next, run `pip install -r requirements.txt` in this repo to install a few more packages required by [CLIP](https://github.com/openai/CLIP). 

# Dataset Installation

Follow [DATASETS.md](DATASETS.md) to install the downstream datasets. We use the [CoOp](https://github.com/KaiyangZhou/CoOp) split of data (including the few-shot splits for seed 1-3, except for ImageNet).


## Path Configuration

You should modify the paths to dataset and results at [prompt.py](prompt.py), e.g., you may want to modify the `args.data_dir` to where you install all the datasets. Default is to save under the current folder.

## Sample few-shot train/val split

We already provide few-shot train/val splits for seed (1, 2, 3), and shots (1, 2, 4, 8, 16) in [indices/](indices/), as if they were generated from the original [CoOp codebase](https://github.com/KaiyangZhou/CoOp) (except for ImageNet that we sampled our own split). If you just intend to follow CoOp's protocol, you may proceed to the next step.

If you want to generate more splits with different shots and seeds, please refer to [few_shot_split.py]. For example, to generate a few-shot train/val split for imagenet with seed 6, you may run the below script:

```
python few_shot_split.py --dataset imagenet --train-shot 1 --seed 6
```

## Evaluation 

You should be able to setup your openai_api key at [openai_api.py]. Then, you can do auto auto-prompting in different modes at [auto_prompt.py].

