import os

from engine.datasets.benchmark import Benchmark
from engine.tools.utils import listdir_nohidden

from engine.datasets.imagenet import read_classnames, OPENAI_IMAGENET_CLASSES


class ImageNetSketch(Benchmark):
    """ImageNet-Sketch.

    This dataset is used for testing only.
    """

    dataset_name = "imagenet-sketch"

    def __init__(self, data_dir):
        root = data_dir
        self.dataset_dir = os.path.join(root, self.dataset_name)
        self.image_dir = os.path.join(self.dataset_dir, "images")

        text_file = os.path.join(self.dataset_dir, "classnames.txt")
        classnames = read_classnames(text_file)

        data = self.read_data(classnames)

        super().__init__(train=data, val=data, test=data)
        self.classnames = OPENAI_IMAGENET_CLASSES
        self.lab2cname = {i: c for i, c in enumerate(self.classnames)}

    def read_data(self, classnames):
        image_dir = self.image_dir
        folders = listdir_nohidden(image_dir, sort=True)
        items = []

        for label, folder in enumerate(folders):
            imnames = listdir_nohidden(os.path.join(image_dir, folder))
            classname = classnames[folder]
            for imname in imnames:
                impath = os.path.join(image_dir, folder, imname)
                item = {"impath": impath, "label": label, "classname": classname}
                items.append(item)

        return items
