import json
import os
import random

# a function to load json file
def load_json(path):
    with open(path, 'r') as f:
        data = json.load(f)
    return data

def load_templates(dic):
    templates = []
    for key, _ in dic.items():
        templates.append(key)
    return templates

def load_samples(templates, seed, numOfSamples):
    random.seed(seed)
    random.shuffle(templates)
    # get first numOfSamples templates
    res = templates[:numOfSamples]
    return res

LAION_COCO_DIR = './laion_coco_results/imagenet/laion_coco_10K_seed_0/seed_1/'
SEED = [0,1,2,3,4]
NUM_OF_SAMPLES = 80

laion_coco_dic = load_json(os.path.join(LAION_COCO_DIR, 'results.json'))
laion_coco_templates = load_templates(laion_coco_dic)
print(len(laion_coco_templates))

for S in SEED:
    laion_coco_samples = load_samples(laion_coco_templates, S, NUM_OF_SAMPLES)
    # save the samples using the seed number
    with open(os.path.join(LAION_COCO_DIR, f'laion_coco_samples_seed_{S}.txt'), 'w') as f:
        for sample in laion_coco_samples:
            f.write(sample + '\n')


