def get_message(prompt_method, good_templates_str, bad_templates_str, random_templates_str ,num_templates_from_gpt, dataset):
    if prompt_method == 'good_bad_better':
        p = f"""
Hi ChatGPT, I have two lists of templates: one with good templates and the other with bad templates. There are characteristics that make a template good or bad. Based on these characteristics, give me {num_templates_from_gpt} better template. 
Here is the list of good templates:
{good_templates_str}

Here is the list of bad templates: 
{bad_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""

    elif prompt_method == 'good_better':
        p = f"""
Hi ChatGPT, I have one list of good templates. There are characteristics that make a template good. Based on these characteristics, give me {num_templates_from_gpt} better template.
Here is the list of good templates:
{good_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.     
"""
    
    elif prompt_method == 'CoT_good_bad_better':
        p = f"""
Hi ChatGPT, I have two lists of templates: one with good templates and the other with bad templates. There are characteristics that make a template good or bad. Based on these characteristics, give me {num_templates_from_gpt} better template.
Here is the list of good templates:
{good_templates_str}

Here is the list of bad templates: 
{bad_templates_str}

Here are my requirements:
- Analyze characteristics that make a template good or bad. 
- The analysis should be in a separate paragraph and less than 30 words.
- The template should be less than 15 words.
- Only the template should start with '- ' in a separate line.
- Please avoid outputing anything other than analysis of characteristics and the template. 
"""


    elif prompt_method == 'iterative_monte_carlo':
        p = f"""
Hi ChatGPT, I have one list of templates. Based on these templates, give me {num_templates_from_gpt} template. 
Here is the list of templates:
{good_templates_str}

Here are my requirements:
- Please only reply the template.
- The templates should be semantically similar to the above templates.
- The templates should be less than 15 words.
- The template should have similar structure to the above template.
- Only the templates should start with '- ' in a separate line.    
"""




    elif prompt_method == 'modify':
            p = f"""
Hi ChatGPT, I have two lists of templates: s1 and s2. According to patterns of templates in s1, please modify templates in s2. Give me {num_templates_from_gpt} modified templates.
Here is s1:
{good_templates_str}

Here is s2:
{bad_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""


    elif prompt_method == 'good_bad_better_new':
        p = f"""
Dear ChatGPT, I have two lists of templates: one with good templates and the other with bad templates. 
Here is the list of good templates:
{good_templates_str}

Here is the list of bad templates: 
{bad_templates_str}

There are characteristics that make a template good or bad. Based on the key characteristics, give me {num_templates_from_gpt} better template with less than 25 words.   
Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.  
"""
    elif prompt_method == 'good_better_new':
        p = f"""
Hi ChatGPT, I have one list of good templates. 
Here is the list of good templates:
{good_templates_str}

There are characteristics that make a template good. Based on the key characteristics, give me {num_templates_from_gpt} better template with less than 25 words.   
Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.     
"""
    elif prompt_method == 'test1':  # test1 and test2 are for comparison with local hill climbing
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have two lists of CLIP templates: one with good templates and the other with bad templates. There are characteristics that make a template good or bad. Based on these characteristics, give me {num_templates_from_gpt} better template for image classification while avoiding worse template. 
Here is the list of good templates:
{good_templates_str}

Here is the list of bad templates: 
{bad_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""
    elif prompt_method == 'test2':
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have one list of good CLIP templates. There are characteristics that make a template good. Based on these characteristics, give me {num_templates_from_gpt} better template for image classification. 
Here is the list of good templates:
{good_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""
    elif prompt_method == 'test3': # test2 and test3 are for comparison with different keywords
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have one list of good CLIP templates. There are latent patterns that make a template good. Based on these patterns, give me {num_templates_from_gpt} better template for image classification. 
Here is the list of good templates:
{good_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""
    elif prompt_method == 'test4': # test1 and test3 are for comparison with different keywords
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have two lists of CLIP templates: one with good templates and the other with bad templates. There are latent patterns that make a template good or bad. Based on these patterns, give me {num_templates_from_gpt} better template for image classification while avoiding worse template. 
Here is the list of good templates:
{good_templates_str}

Here is the list of bad templates: 
{bad_templates_str}

Here are my requirements:
- Please only reply with the template.
- The template should be fewer than 15 words.
- The template should have a similar structure to the above template.
- Only the template should start with '- ' on a separate line.    
"""
    elif prompt_method == 'hc':
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have one list of CLIP templates. There are latent patterns that make a template good or bad. Based on these, give me {num_templates_from_gpt} template for image classification. 
Here is the list of templates:
{good_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""
    elif prompt_method == 'hc2': # hc2 is designed to compare with hc to see difference of 'latent pattern'
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have one list of CLIP templates. Based on these templates, give me {num_templates_from_gpt} template for image classification. 
Here is the list of templates:
{good_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""
    elif prompt_method == 'hc3': # hc3 is designed to compare with hc to see difference of 'latent pattern'
        p = f"""
Hi ChatGPT, assume you are a pattern learner. Give me {num_templates_from_gpt} template for image classification. 
Here is a list of example templates:
{good_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""

    elif prompt_method == 'test5': # compared with test4 to see if instructions tuning works. However, no significant improvement and will result in formatting problems.
        p = f"""
Hi ChatGPT, as a pattern learner, I need you to analyze two lists of CLIP templates: one containing good templates and the other containing bad templates. Identify the latent patterns that distinguish the good templates from the bad ones. Then, generate {num_templates_from_gpt} improved templates for image classification, avoiding the patterns found in the bad templates.

Good templates:
{good_templates_str}

Bad templates:
{bad_templates_str}

When providing your suggestions, please adhere to the following requirements:

- Only provide the template as your response.
- Ensure the template is no more than 15 words long.
- Maintain a similar structure to the provided templates.
- Begin each template with '- ' on a new line.  
"""
    elif prompt_method == 'test6': # compared with test5 to see if CoT works. However, no significant improvement.
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have one list of CLIP templates. Based on these templates, please analyze the latent patterns and give me {num_templates_from_gpt} template for image classification. 
Here is the list of templates:
{good_templates_str}

Here are my requirements:
- Please reply your analysis followed by the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line. 
"""
    elif prompt_method == 'test7': # This is to see if stating dataset helps. However, it seems that it will add the dataset names to given templates.
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have one list of CLIP templates. Based on these templates, give me {num_templates_from_gpt} template for image classification on {dataset}. 
Here is the list of templates:
{good_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""

    elif prompt_method == 'test8': # whether leaking dataset name will help
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have one list of CLIP templates. Based on these templates, give me {num_templates_from_gpt} template for image classification on {dataset}. 
Here is the list of templates:
{good_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""
    elif prompt_method == 'test9':
        p = f"""
Hi ChatGPT, assume you are a pattern learner. I have one list of CLIP templates: one with good templates. There are latent patterns that make a template good. Based on these patterns, give me {num_templates_from_gpt} better template for image classification. 
Here is the list of good templates:
{good_templates_str}

Here are my requirements:
- Please only reply with the template.
- The template should be fewer than 15 words.
- The template should have a similar structure to the above template.
- Only the template should start with '- ' on a separate line.    
"""
    elif prompt_method == 'test10': # no hc good only
        p = """
Hi ChatGPT, assume you are a pattern learner. I have one list of CLIP templates: one with good templates. There are latent patterns that make a template good. Based on these patterns, give me 1 better template for image classification. 
Here is the list of good templates:
An {} with a tassel hanging from it.
A {} with the word journey on it.
An {} with a large wall mural in the middle.
A {} with a headband is holding her hair.
A {} with bright makeup and colorful hair.
An aerial view of a {} with yellow and blue paint.
A {} with food storage containers and fruits.
an {} on a white background
A {} with a clock tower and a bell.
{} standing next to each other in front of a yellow background.
An {} embracing in front of the sun.
{} are set in blue and white crystals.
A {} showing the number and percentage of names in different countries.
A {} with power supply and accessories.
The {} for Kooperativa Vienna Insurance Group.

Here are my requirements:
- Please only reply with the template.
- The template should be fewer than 15 words.
- The template should have a similar structure to the above template.
- Only the template should start with '- ' on a separate line. 
"""
    elif prompt_method == 'test11': # no hc good bad
        p = """
Hi ChatGPT, assume you are a pattern learner. I have two lists of CLIP templates: one with good templates and the other with bad templates. There are latent patterns that make a template good or bad. Based on these patterns, give me 1 better template for image classification while avoiding worse template. 
Here is the list of good templates:
An {} with a tassel hanging from it.
A {} with the word journey on it.
An {} with a large wall mural in the middle.
A {} with a headband is holding her hair.
A {} with bright makeup and colorful hair.
An aerial view of a {} with yellow and blue paint.
A {} with food storage containers and fruits.
an {} on a white background
A {} with a clock tower and a bell.
{} standing next to each other in front of a yellow background.
An {} embracing in front of the sun.
{} are set in blue and white crystals.
A {} showing the number and percentage of names in different countries.
A {} with power supply and accessories.
The {} for Kooperativa Vienna Insurance Group.

Here is the list of bad templates: 
{} attends the premiere for'Black Rockler Focus on August 19, 2017, in Los Angeles.
Silver and copper items including cups, plates, {}, and other objects.
Two Ups invertors with the {} High Frequency Online Ups
The walking dead action figure has been made to look like he is holding his {}.
Scotts Turf Builder, {}, winterguard, weed, and feed.
the cover to Anthony Horowitz's battles and {}.
An advertisement for the upcoming smartphones in {}.
The planet with two large clouds in {}.
Modern house with outdoor living area and {}.
Pickles in a jar with the {} How To Make Flatteng Probiotictic Pickles
Anusha and Varish at the {}.
Dalmatian dog sitting down on the ground, grass, animal, and {}.
The cat is wearing a {} and holding two spoons.
Neym, {} and the most important player.
A painting of soldiers marching in {}.

Here are my requirements:
- Please only reply with the template.
- The template should be fewer than 15 words.
- The template should have a similar structure to the above template.
- Only the template should start with '- ' on a separate line.    
"""


    elif prompt_method == 'test14': # it is the same as test4 but for longer templates
            p = f"""
Hi ChatGPT, assume you are a pattern learner. I have two lists of CLIP templates: one with good templates and the other with bad templates. There are latent patterns that make a template good or bad. Based on these patterns, give me {num_templates_from_gpt} better template for image classification while avoiding worse template. 
Here is the list of good templates:
{good_templates_str}

Here is the list of bad templates: 
{bad_templates_str}

Here are my requirements:
- Please only reply with the template.
- The template should be fewer than 25 words.
- The template should have a similar structure to the above template.
- Only the template should start with '- ' on a separate line.    
    """

    elif prompt_method == 'test15': # only difference between 4 is I changed templates to prompts
            p = f"""
Hi ChatGPT, assume you are a pattern learner. I have two lists of CLIP prompts: one with good prompts and the other with bad prompts. There are latent patterns that make a prompt good or bad. Based on these patterns, give me {num_templates_from_gpt} better prompt for image classification while avoiding worse prompt. 
Here is the list of good prompts:
{good_templates_str}

Here is the list of bad prompts: 
{bad_templates_str}

Here are my requirements:
- Please only reply with the prompt.
- The prompt should be fewer than 15 words.
- The prompt should have a similar structure to the above prompt.
- Only the prompt should start with '- ' on a separate line.     
    """
    
    elif prompt_method == 'test16': # topk + random k
         p = f"""
Hi ChatGPT, assume you are a pattern learner. I have two lists of CLIP templates: one with good templates and the other with random templates. There are latent patterns that make a template good. Based on these patterns, give me {num_templates_from_gpt} better template for image classification. 
Here is the list of good templates:
{good_templates_str}

Here is the list of random templates: 
{random_templates_str}

Here are my requirements:
- Please only reply with the template.
- The template should be fewer than 15 words.
- The template should have a similar structure to the above template.
- Only the template should start with '- ' on a separate line.    
"""
    elif prompt_method == 'test17': # random k
        p = f"""
Hi ChatGPT, assume you are a pattern learner. Give me {num_templates_from_gpt} template for image classification. 
Here is a list of random templates:
{random_templates_str}

Here are my requirements:
- Please only reply the template.
- The template should be less than 15 words.
- The template should have similar structure to the above template.
- Only the template should start with '- ' in a separate line.    
"""
    elif prompt_method == 'test18':
         p = f"""
Hi ChatGPT, assume you are a pattern learner. I have two lists of CLIP templates: one with good templates and the other with bad templates. There are latent patterns that make a template good or bad. Based on these patterns, give me {num_templates_from_gpt} better template while avoiding worse template for image classification on {dataset}. ImageNet is an image database organized according to the WordNet hierarchy (currently only the nouns), in which each node of the hierarchy is depicted by hundreds and thousands of images.  
Here is the list of good templates:
{good_templates_str}

Here is the list of bad templates: 
{bad_templates_str}

Here are my requirements:
- Please only reply with the template.
- The template should be fewer than 15 words.
- The template should have a similar structure to the above template.
- Only the template should start with '- ' on a separate line.    
"""
         

    return p
    
