# Taylor Expansion for MLP Replacement

## Project Overview

This project implements a novel approach to replace Multi-Layer Perceptron (MLP) layers in neural networks with Taylor Expansion approximations. By combining K-means clustering and first-order Taylor expansion, we achieve significant computational efficiency while maintaining competitive accuracy.

Codes are modified from https://github.com/weiaicunzai/pytorch-cifar100.git

## Core Scripts

- **kmeans_data_collect.py** - Collect intermediate layer outputs for K-means training
- **Kmeans_learn.py** - Train K-means clustering models
- **taylor_learn.py** - Compute Taylor expansion coefficients
- **taylor_acc_test.py** - Test accuracy of Taylor approximation
- **taylor_mse_test.py** - Test mean squared error performance
- **taylor_time_test.py** - Test computational timing performance
- **train.py** - Original model training script

## Complete Workflow

### Step 0: Original Model Training

Train the original VGG 16 model on the Cifar-100 dataset

```bash
python train.py -net vgg16
```

### Step 1: Data Collection

Collect intermediate layer outputs from the trained network:

```bash
python kmeans_data_collect.py -net vgg16 -weights path to your model
```

### Step 2: K-means Training

Train multiple K-means models with different cluster counts:

```bash
python Kmeans_learn.py -f kmeans_data.npy
```

### Step 3: Taylor Coefficients Calculation

Compute Taylor expansion coefficients for each K-means model:

```bash
python taylor_learn.py -net vgg16 -weights path to your models -kpath path to kmeans 
```

### Step 4: Accuracy Testing

Evaluate the accuracy of Taylor approximation:

```bash
python taylor_acc_test.py -net vgg16 -weights path to your model -kpath kmeans_models -tpath path to your parameters
```

### Step 5: Timing Performance

Test computational performance:

```bash
python taylor_time_test.py -net vgg16 -weights path to your model -kpath kmeans_models -tpath path to your parameters
```


### Step 6: MSE Performance

MSE computational performance:



```bash
python taylor_mse_test.py -net vgg16 -weights path to your model -kpath kmeans_models -tpath path to your parameters
```
