import argparse

def get_args_parser():
    parser = argparse.ArgumentParser('CSG-Score',
                                     add_help=False)
    parser.add_argument('--seed', default=42, type=int)
    parser.add_argument('--batch_size', default=1, type=int)
    parser.add_argument('--num_workers', default=10, type=int)
    parser.add_argument('--compute_refcsg', type=bool, default=True)
    parser.add_argument('--device', default="cuda:0", type=str)
    # Path
    parser.add_argument('--dataset_name', default="example", type=str)
    parser.add_argument('--data_root', default="example/one_image", type=str)
    parser.add_argument('--candidates_json', type=str,
                        default='example/detailed_captions.json')
    parser.add_argument('--references_json', type=str, default='example/one_image_refs.json')

    # Hyper Param
    parser.add_argument('--vlm_temp', default=1.0, type=float)
    # Model

    parser.add_argument(
        '--sg_model',
        type=str,
        default="flan-t5-base-VG-factual-sg",
    )
    parser.add_argument(
        '--vlm',
        type=str,
        default="alpha-CLIP",
        help='Path to the pretrained model, only the mask head will be trained'
    )
    parser.add_argument(
        '--vlm_type',
        type=str,
        default="alpha-CLIP",
    )


    # mobile SAM
    parser.add_argument("--ObjectAwareModel_path", type=str, default='./PromptGuidedDecoder/ObjectAwareModel.pt', help="ObjectAwareModel path")
    parser.add_argument("--Prompt_guided_Mask_Decoder_path", type=str, default='./PromptGuidedDecoder/Prompt_guided_Mask_Decoder.pt', help="Prompt_guided_Mask_Decoder path")
    parser.add_argument("--encoder_path", type=str, default="efficientvit_l2", help="select your own path")
    # parser.add_argument("--img_path", type=str, default="./test_images/", help="path to image file")
    parser.add_argument("--imgsz", type=int, default=1024, help="image size")
    parser.add_argument("--iou",type=float,default=0.9,help="yolo iou")
    parser.add_argument("--conf", type=float, default=0.4, help="yolo object confidence threshold")
    parser.add_argument("--retina",type=bool,default=True,help="draw segmentation masks",)
    # parser.add_argument("--output_dir", type=str, default="./", help="image save path")
    parser.add_argument("--encoder_type", default='efficientvit_l2',choices=['tiny_vit','sam_vit_h','mobile_sam','efficientvit_l2','efficientvit_l1','efficientvit_l0'], help="choose the model type")

    args = parser.parse_args()

    return args