import tensorflow as tf
import numpy as np


class NPWithoutReplacementSampler():

    def __init__(
        self,
        values: np.ndarray,
        size: int
    ) -> None:
        self.values = values
        self.size = size

    def sample(
        self
    ):
        np.random.shuffle(self.values)

        return self.values[:self.size]


class TFWithoutReplacementSampler():

    def __init__(
        self,
        values: tf.Tensor,
        size: int
    ) -> None:
        self.values = values
        self.size = size

    def sample(
        self
    ):
        values = tf.random.shuffle(self.values)

        return values[:self.size]


class TFFrozenSampler():

    def __init__(
        self,
        values: tf.Tensor
    ) -> None:
        self.values = values

    def sample(self) -> tf.Tensor:
        return self.values
