import torch
from torch import nn


class IsotropicScaling(nn.Module):
    def __init__(self):
        super().__init__()
        self.scale_factor = nn.Parameter(torch.randn(1))

    def forward(self, x):
        return self.scale_factor * x


class Translation(nn.Module):
    def __init__(self, shape):
        super().__init__()
        self.translation = nn.Parameter(torch.randn(1, shape))

    def forward(self, x):
        return x + self.translation


class LinearTransformation(nn.Module):
    def __init__(self, shape):
        super().__init__()
        self.linear_transformation = nn.Parameter(torch.randn(shape, shape))

    def forward(self, x):
        return x @ self.linear_transformation
