#!/bin/bash

# Define the arrays for context_length and percent_name
context_lengths=(512 1024 2048 4096 6144 8192 10927)
percent_names=(100p0)
token_numbers=(200000000 250000000)

# Loop through each context_length
for context_length in "${context_lengths[@]}"; do
  # Loop through each percent_name
  for percent_name in "${percent_names[@]}"; do
    for token_number in "${token_numbers[@]}"; do
      # Run the python script with the current parameters
      python3 create_config.py --context_length $context_length --percent_name $percent_name --train_token_number $token_number
    done
  done
done