# setup the environment
echo `date`, Setup the environment ...
set -e  # exit if error

# prepare folders
datasets_path=/datasets/human_llm_data_for_experiment

# results folders
statistic_detection_results_path=/experiment_results/statistic_detection_results
fast_detectgpt_detection_results_path=/experiment_results/fast_detectgpt_detection_results
lastde_doubleplus_detection_results_path=/experiment_results/lastde_doubleplus_detection_results

# open-source
datasets="xsum" # xsum squad writing
source_models="llama3_8b" # gpt2_xl gptneo_2.7b opt_2.7b gptj_6b llama1_13b llama2_13b llama3_8b opt_13b bloom_7b falcon_7b gemma_7b phi2
scenarios="white"

# statistic methods：likelihood, logrank, entropy, lrr, lastde
for D in $datasets; do
for M in $source_models; do
   echo `date`, Preparing dataset ${D}_${M} ...
   python ../py_scripts/baselines/statistic_detect.py --dataset_file ${datasets_path}/${D}_${M} --output_file ${statistic_detection_results_path}/${D}_${M}_${scenarios}  --scoring_model_name ${M}
 done
done


# sampling methods: fast_detectgpt, lastde++
for D in $datasets; do
 for M in $source_models; do
   echo `date`, Preparing dataset ${D}_${M} ...
   python ../py_scripts/baselines/fast_detect_gpt.py --dataset_file ${datasets_path}/${D}_${M} --output_file ${fast_detectgpt_detection_results_path}/${D}_${M}_${scenarios} --reference_model_name ${M} --scoring_model_name ${M}
 done
done


for D in $datasets; do
 for M in $source_models; do
   echo `date`, Preparing dataset ${D}_${M} ...
   python ../py_scripts/baselines/lastde_doubleplus.py --dataset_file ${datasets_path}/${D}_${M} --output_file ${lastde_doubleplus_detection_results_path}/${D}_${M}_${scenarios} --reference_model_name ${M} --scoring_model_name ${M}  --embed_size 4 --epsilon 8 --tau_prime 15
 done
done
exit