# setup the environment
echo `date`, Setup the environment ...
set -e  # exit if error

# prepare folders
datasets_path=/datasets/human_llm_data_for_experiment

# results folders
statistic_detection_results_path=/experiment_results/statistic_detection_results
fast_detectgpt_detection_results_path=/experiment_results/fast_detectgpt_detection_results
lastde_doubleplus_detection_results_path=/experiment_results/lastde_doubleplus_detection_results

# opened-source and closed-source
datasets="xsum" # xsum writing reddit
source_models="llama3_8b"  # gpt2_xl gptneo_2.7b opt_2.7b llama1_13b llama2_13b llama3_8b opt_13b bloom_7b falcon_7b gemma_7b phi2 gpt4turbo
scenarios="black"
proxy_model="gptj_6b"

# statistic methods：likelihood、logrank、entropy、lrr、lmde
for D in $datasets; do
for M in $source_models; do
   echo `date`, Preparing dataset ${D}_${M} ...
   python ../py_scripts/baselines/statistic_detect.py --dataset_file ${datasets_path}/${D}_${M} --output_file ${statistic_detection_results_path}/${D}_${M}_${scenarios}  --scoring_model_name ${proxy_model}
 done
done

# sampling methods: fast_detectgpt、fast_lmde
for D in $datasets; do
 for M in $source_models; do
   echo `date`, Preparing dataset ${D}_${M} ...
   python ../py_scripts/baselines/fast_detect_gpt.py --dataset_file ${datasets_path}/${D}_${M} --output_file ${fast_detectgpt_detection_results_path}/${D}_${M}_${scenarios} --reference_model_name ${proxy_model} --scoring_model_name ${proxy_model}
 done
done


for D in $datasets; do
 for M in $source_models; do
   echo `date`, Preparing dataset ${D}_${M} ...
   python ../py_scripts/baselines/lastde_doubleplus.py --dataset_file ${datasets_path}/${D}_${M} --output_file ${lastde_doubleplus_detection_results_path}/${D}_${M}_${scenarios} --reference_model_name ${proxy_model} --scoring_model_name ${proxy_model}  --embed_size 4 --epsilon 8 --tau_prime 15
 done
done
exit