import sys
sys.path.append('..')

import numpy as np
import pandas as pd
import os

store_data_path = '../store_data/'
if not os.path.exists(store_data_path):
    os.mkdir(store_data_path)

higher_dimension_store_path = store_data_path + 'higher_dimension/'
if not os.path.exists(higher_dimension_store_path):
    os.mkdir(higher_dimension_store_path)
    
ground_truth_path = higher_dimension_store_path + 'ground_truth/'
if not os.path.exists(ground_truth_path):
    os.mkdir(ground_truth_path)

from simulate_poisson_process_v2 import *

np.random.seed(1)
T_max = 10
d = 4
N = 50

scipy_multivar_norm = get_scipy_multivar_gauss(T_max, d)
scipy_mixture = create_mixture_of_pdf(T_max, d, N, get_scipy_multivar_gauss)

N_samples = 100
bin_location = np.linspace(0, T_max, N_samples+1)
bin_location = (bin_location[:-1] + bin_location[1:]) / 2

process = np.array([1, 2, 3, 4])
bin_location_diagonal = np.array([(b,b,b,b) for b in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=0)
pdf /= np.sum(pdf)
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([1, 2, 3])
bin_location_diagonal = np.array([[(b,b,b,i) for b in bin_location] for i in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([1, 2, 4])
bin_location_diagonal = np.array([[(b,b,i,b) for b in bin_location] for i in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([1, 3, 4])
bin_location_diagonal = np.array([[(b,i,b,b) for b in bin_location] for i in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([2, 3, 4])
bin_location_diagonal = np.array([[(i,b,b,b) for b in bin_location] for i in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([1, 2])
bin_location_diagonal = np.array([[[(b,b,i,j) for b in bin_location] for i in bin_location] for j in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([1, 3])
bin_location_diagonal = np.array([[[(b,i,b,j) for b in bin_location] for i in bin_location] for j in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([1, 4])
bin_location_diagonal = np.array([[[(b,i,j,b) for b in bin_location] for i in bin_location] for j in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([2, 3])
bin_location_diagonal = np.array([[[(i,b,b,j) for b in bin_location] for i in bin_location] for j in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([2, 4])
bin_location_diagonal = np.array([[[(i,b,j,b) for b in bin_location] for i in bin_location] for j in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([3, 4])
bin_location_diagonal = np.array([[[(i,j,b,b) for b in bin_location] for i in bin_location] for j in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([1])
bin_location_diagonal = np.array([[[[(b,i,j,k) for b in bin_location] for i in bin_location] for j in bin_location] for k in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2,3))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([2])
bin_location_diagonal = np.array([[[[(i,b,j,k) for b in bin_location] for i in bin_location] for j in bin_location] for k in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2,3))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([3])
bin_location_diagonal = np.array([[[[(i,j,b,k) for b in bin_location] for i in bin_location] for j in bin_location] for k in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2,3))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)

process = np.array([4])
bin_location_diagonal = np.array([[[[(i,j,k,b) for b in bin_location] for i in bin_location] for j in bin_location] for k in bin_location])
pdf = np.sum(np.array([distribution.pdf(bin_location_diagonal) for distribution in scipy_mixture]), axis=(0,1,2,3))
pdf /= np.sum(pdf) / (bin_location[1] - bin_location[0])
# plt.plot(bin_location, pdf)
# plt.title('Process: {}'.format(process))
pd.DataFrame(np.array([bin_location, pdf]).T, columns=['Bin Location', 'pdf']).to_csv('{}/p{}.csv'.format(ground_truth_path, ''.join(np.array(process, dtype=str))), index=False)
















