import sys
sys.path.append('..')


import numpy as np
import pandas as pd
from scipy import stats
from scipy import signal
import matplotlib.pyplot as plt

import matplotlib
font = {'family' : 'normal',
        'weight' : 'bold',
        'size'   : 15}
matplotlib.rc('font', **font)

from IGPPP import IGPPP
from simulate_poisson_process import *
import os

results_path = '../results/'
if not os.path.exists(results_path):
    os.mkdir(results_path)
    
store_data_path = '../store_data/'
if not os.path.exists(store_data_path):
    os.mkdir(store_data_path)

intensity_list = list()
np.random.seed(1)


X = np.random.binomial(1,0.1,100)
T = np.array(range(len(X)))
IGPPP_model = IGPPP(T[X==1], 1 ,100, kernel_estimator=False)
IGPPP_model.train(100, natural_gradient=True, verbose=False, verbose_step=10)
plt.plot(IGPPP_model.get_intensity(), linewidth=3)
intensity_list.append(np.squeeze(IGPPP_model.get_intensity()))


h_list = [1, 2, 5, 10, 50]
for h in h_list:
    np.random.seed(1)
    X = np.random.binomial(1,0.1,100)
    T = np.array(range(len(X)))
    IGPPP_model = IGPPP(T[X==1], 1,100, kernel_estimator=True, h=h)
    IGPPP_model.train(100, natural_gradient=True, verbose=False, verbose_step=10)
    plt.plot(IGPPP_model.get_intensity(), linewidth=3)
    intensity_list.append(np.squeeze(IGPPP_model.get_intensity()))

plt.plot(T[X==True], np.zeros(len(T[X==True])), 'ok')
plt.legend(['No Kernel', 'Gaussian Kernel, h=1', 'Gaussian Kernel, h=2', 'Gaussian Kernel, h=5', 'Gaussian Kernel, h=10'])
plt.xlabel('Time', fontsize=16, fontweight='bold')
plt.ylabel('Intensity', fontsize=16, fontweight='bold')

toy_example_path = results_path + 'toy_example/'
if not os.path.exists(toy_example_path):
    os.mkdir(toy_example_path)
plt.tight_layout()
plt.savefig('{}varying_kernel_bandwidth.eps'.format(toy_example_path), format='eps')
plt.savefig('{}varying_kernel_bandwidth.png'.format(toy_example_path), format='png', dpi=1200)

toy_example_store_path = store_data_path + 'toy_example/'
if not os.path.exists(toy_example_store_path):
    os.mkdir(toy_example_store_path)
pd.DataFrame(np.array(intensity_list).T, columns=['h=0', 'h=1', 'h=2', 'h=5', 'h=10', 'h=50']).to_csv('{}toy_example_intensity.csv'.format(toy_example_store_path), index=False)
pd.DataFrame(np.array([T, X]).T, columns=['Time', 'Observations']).to_csv('{}toy_example_time_observations.csv'.format(toy_example_store_path), index=False)
pd.DataFrame(T[X==1], columns=['Observations']).to_csv('{}toy_example_obersvations.csv'.format(toy_example_store_path), index=False)
