import sys
sys.path.append('..')


import numpy as np
import pandas as pd
from scipy import stats
from scipy import signal
import matplotlib.pyplot as plt

import matplotlib
font = {'family' : 'normal',
        'weight' : 'bold',
        'size'   : 15}
matplotlib.rc('font', **font)

from IGPPP import IGPPP

from simulate_poisson_process import *

import os

results_path = '../results/'
if not os.path.exists(results_path):
    os.mkdir(results_path)
    
store_data_path = '../store_data/'
if not os.path.exists(store_data_path):
    os.mkdir(store_data_path)


np.random.seed(1)
T = 100
t_vec = np.arange(100)
lam_t_vec = 1 + np.sin(t_vec/10)

obs = thinning_algorithm(lam_t_vec)

thinning_algorithm_sparse_path = results_path + 'thinning_algorithm_sparse/'
if not os.path.exists(thinning_algorithm_sparse_path):
    os.mkdir(thinning_algorithm_sparse_path)

thinning_algorithm_sparse_store_path = store_data_path + 'thinning_algorithm_sparse/'
if not os.path.exists(thinning_algorithm_sparse_store_path):
    os.mkdir(thinning_algorithm_sparse_store_path)

pd.DataFrame(np.array([np.arange(len(lam_t_vec)), lam_t_vec]).T, columns=['Time', 'Intensity']).to_csv('{}ground_truth_intensity.csv'.format(thinning_algorithm_sparse_store_path), index=False)
pd.DataFrame(obs, columns=['Obervations']).to_csv('{}thinning_algorithm_sparse_obervations.csv'.format(thinning_algorithm_sparse_store_path), index=False)

intensity_list = list()

h_list = [0.3, 1, 2, 4, 5, 10, 50]
for h in h_list:
    IGPPP_model = IGPPP(obs,1,100, kernel_estimator=True, h=h)
    IGPPP_model.train(100, natural_gradient=True, verbose=False, verbose_step=1)

    intensity_list.append(np.squeeze(IGPPP_model.get_intensity()))
    plt.plot(IGPPP_model.get_intensity(), linewidth=3)
    plt.plot(lam_t_vec, 'k')
    plt.plot(obs, np.zeros(len(obs)), '.k')
    plt.xlabel('Time', fontsize=16, fontweight='bold')
    plt.ylabel('Intensity', fontsize=16, fontweight='bold')
    plt.legend(['IGPPP', 'Ground Truth'], ncol=2)
    plt.tight_layout()
    plt.savefig('{}thinning_algorithm_sparse_h{}.eps'.format(thinning_algorithm_sparse_path, str(h).replace(".", "")), format='eps')
    plt.savefig('{}thinning_algorithm_sparse_h{}.png'.format(thinning_algorithm_sparse_path, str(h).replace(".", "")), format='png', dpi=1200)

pd.DataFrame(np.array(intensity_list).T, columns=['h=0.3', 'h=1', 'h=2', 'h=4', 'h=5', 'h=10', 'h=50']).to_csv('{}intensity.csv'.format(thinning_algorithm_sparse_store_path), index=False)
