import argparse


def get_arguments():
    parser = argparse.ArgumentParser(description="Bert: Backdoor Detection and Unlearning")

    parser.add_argument("--seed", type=list, default=[2021, 2022, 2023])
    parser.add_argument("--tokenizer", type=str, default="bert-base-uncased")
    parser.add_argument("--victim_model", type=str, default="bert-base-uncased")

    parser.add_argument("--poisoning_epoch", type=int, default=5)
    parser.add_argument("--dataset", type=str, default="SST-2", help="SST-2, HSOL, AG")
    parser.add_argument("--attack_mode", type=str, default="HiddenKiller", help="BadNet, AddSent, HiddenKiller")

    parser.add_argument("--max_len", type=int, default=128)
    parser.add_argument("--learning_rate", type=float, default=2e-5)
    parser.add_argument("--batch_size", type=int, default=32)

    # Detection Part: UMAP and HDBSCAN parameters
    parser.add_argument("--min_cluster", type=int, default=150)
    parser.add_argument("--min_samples", type=int, default=120)
    parser.add_argument("--umap_n_neighbors", type=int, default=100)
    parser.add_argument("--umap_min_dist", type=float, default=0.25)

    # Unlearning Part: [RT:Retrain, GA: Gradient Ascent, NPO: Negative Preference Optimization, RGA:Robust GA]
    parser.add_argument("--unlearning_method", type=str, default="RT", help="RT, GA, NPO, RGA")
    parser.add_argument("--unlearning_epoch", type=int, default=30)

    return parser