import re

with open("/.../EVAL.out", "r") as f:
    content = f.read()

blocks = re.split(r"(?=initial accuracy:|Traceback \(most recent call last\):)", content)

formatted = []
for block in blocks:
    if "FileNotFoundError" in block:
        formatted.append("00,00/00,00")
    else:
        init = re.search(r"initial accuracy:\s*([\d.]+)%", block)
        rob = re.search(r"robust accuracy:\s*([\d.]+)%", block)
        if init and rob:
            formatted.append(f"{init.group(1).replace('.', ',')}/{rob.group(1).replace('.', ',')}")
        else:
            formatted.append("00,00/00,00")

with open("formatted_results.txt", "w") as f:
    f.write("\n".join(formatted))
