#!/bin/bash

{
# run a training - TSP100
# python experiments/train.py environment.num_cities=100

# run slow rl eval - with loaded instances
# 10000 instances of size 100 (loaded)
python experiments/slowrl_validate.py slowrl.batch_size=125 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/tsp100_test_seed1234.pkl" slowrl.problems.num_problems=10000 slowrl.environment.num_cities=100
# 1000 instances of size 125 (loaded)
python experiments/slowrl_validate.py slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/tsp125_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_cities=125
# 1000 instances of size 150 (loaded)
python experiments/slowrl_validate.py slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/tsp150_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_cities=150
# 1000 instances of size 175 (loaded)
python experiments/slowrl_validate.py slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/tsp175_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_cities=175
# 1000 instances of size 200 (loaded)
python experiments/slowrl_validate.py slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/tsp200_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_cities=200
# 1000 instances of size 225 (loaded)
python experiments/slowrl_validate.py slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/tsp225_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_cities=225
# 1000 instances of size 250 (loaded)
python experiments/slowrl_validate.py slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/tsp250_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_cities=250



# 10000 instances of size 100 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp100_test_seed1234.pkl" slowrl.problems.num_problems=10000 slowrl.environment.num_nodes=100 slowrl.environment.norm_factor=50
# 1000 instances of size 125 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp125_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_nodes=125 slowrl.environment.norm_factor=55
# 1000 instances of size 150 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp150_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_nodes=150 slowrl.environment.norm_factor=60
# 1000 instances of size 175 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp175_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_nodes=175 slowrl.environment.norm_factor=65
# 1000 instances of size 200 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=5 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp200_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_nodes=200 slowrl.environment.norm_factor=70
# 1000 instances of size 225 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=5 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp225_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_nodes=225 slowrl.environment.norm_factor=75
# 1000 instances of size 250 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=5 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp250_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_nodes=250 slowrl.environment.norm_factor=80


}