import ml_collections
import numpy as np


def get_config():
    config = ml_collections.ConfigDict()
    config.env_name = "hopper-hop"
    config.exp_name = "ce"
    config.seed = 0 
    config.earlystop = 500

    config.emb_dim = 64
    config.contrast_ups = 2
    config.contrast_batch_size = 256
    config.temperature = 0.1

    config.k = 20
    config.horizon = 5
    config.memory_skip = 5
    config.memory_size = 300

    config.lmbda = 0.2
    config.epsilon = 0.2

    return config
