- Install pytorch with GPU support
- Install the other requirements using the following command:
```pip install -r requirements.txt```
You might also need to install `transformers` to use huggingface's pretrained models.
- Set the rootdir in kbgen/config.py to where you want to save things
- Take a quick look at `exploration_gsm.ipynb` to get a feel for the dataset and the preprocessing steps (as well as figure out how to download the data!). I'm not sure if there's a way to get around the Kaggle API but you can install the python package (in the requirements) then run `kaggle datasets download -d msainani/gsmarena-mobile-devices`" Then unzip the file and place it in the data folder (which should be `os.path.join(rootdir, "/data/gsm")`) using `unzip gsmarena-mobile-devices.zip gsm.csv`.

Then, run the following command to train the model:
``python train.py --wandb 1`` (wandb 1 logs to wandb and makes sure you save models)

For evaluation, look at the ``eval_models.py`` (add the run that you just ran with wandb).

You can play around with diffusion in ``diffusion_example_by_hand.py``

Note that this does not reproduce the results in the paper, these take way longer to run.
This material serves the purpose of demonstrating the codebase and the general idea of the project.

## Repository Structure
General file structure, files you may care about:
```
train.py
exploration_gsm.ipynb
kbgen/
  ├── diffusion.py
  ├── Trainer.py
  └── model/
        └── model.py
        └── positional_encodings.py
  └── data/
        └── datasets.py
```
