import argparse
import torch
import datetime
import json
import yaml
import os

from main_model import SFdiff
from dataset_forecasting import get_dataloader
from utils import train, evaluate

parser = argparse.ArgumentParser(description="SFdiff")
parser.add_argument("--config", type=str, default="base_forecasting.yaml")
parser.add_argument("--datatype", type=str, default="electricity")
parser.add_argument('--device_idx', default=1, type=int)
parser.add_argument("--seed", type=int, default=1)
parser.add_argument("--unconditional", action="store_true")
parser.add_argument("--modelfolder", type=str, default="forecasting")
parser.add_argument("--nsample", type=int, default=100)
parser.add_argument("--nstep", type=int, default=50)
parser.add_argument("--train", default=False)
parser.add_argument("--ode_sampling", default=False)
parser.add_argument("--predictor", type=str, default="euler_maruyama")
parser.add_argument("--corrector", type=str, default="none")
parser.add_argument("--history_length", type=int, default=72)
parser.add_argument("--code", type=str, default="")
parser.add_argument("--get_std", default=True)

args = parser.parse_args()
# print(args)
args.device = f"cuda:{args.device_idx}"

path = "config/" + args.config
with open(path, "r") as f:
    config = yaml.safe_load(f)

if args.datatype == 'electricity':
    target_dim = 370
elif args.datatype == 'solar':
    target_dim = 137
elif args.datatype == 'traffic':
    target_dim = 963
elif args.datatype == 'exchange':
    target_dim = 8
elif args.datatype == 'wiki':
    target_dim = 2000
elif args.datatype == 'taxi':
    target_dim = 1214

config["model"]["is_unconditional"] = args.unconditional

config["diffusion"]['num_steps'] = args.nstep

# print(json.dumps(config, indent=4))

# current_time = datetime.datetime.now().strftime("%Y%m%d_%H%M%S")
args.modelfolder = f'{args.modelfolder}_{args.code}'
foldername = f"./save/{args.modelfolder}_" + args.datatype + "/"

print('model folder:', foldername)
os.makedirs(foldername, exist_ok=True)
with open(foldername + "config.json", "w") as f:
    json.dump(config, f, indent=4)

train_loader, valid_loader, test_loader, scaler, mean_scaler = get_dataloader(
    datatype=args.datatype,
    device= args.device,
    batch_size=config["train"]["batch_size"],
    history_length=args.history_length,
)

model = CSDI_Forecasting(config, args.device, target_dim).to(args.device)

if args.train:
    train(
        model,
        config["train"],
        train_loader,
        valid_loader=valid_loader,
        foldername=foldername,
    )

evaluate(
    model,
    test_loader,
    nsample=args.nsample,
    scaler=scaler,
    mean_scaler=mean_scaler,
    foldername=foldername,
    args=args,
)
