# FedALS

Communication Efficient Federated Representation Learning

Abstract: The Federated Averaging (FedAvg) algorithm is a widely uti-
lized technique in Federated Learning. It follows a recursive
pattern where nodes perform a few local stochastic gradi-
ent descents (SGD), and then the central server updates the
model by taking an average. The primary purpose of con-
ducting model averaging is to mitigate the consensus error
that arises between models across different nodes. In our em-
pirical examination, it becomes evident that in non-iid data
distribution setting, the consensus error in the initial layers
of deep neural network is considerably smaller than that ob-
served in the later layers. This observation hints at the feasi-
bility of applying a less intensive averaging approach for the
initial layers. Typically, these layers are designed to extract
meaningful representations from the neural network’s input.
To delve deeper into this phenomenon, we formally analyze it
within the context of linear representation. We illustrate that
increasing the number of local SGD iterations or reducing the
frequency of averaging for the representation extractor leads
to enhanced generalizability in the learned model produced
by FedAvg’s output. The paper is followed with experimental
results showing the effectiveness of this method

## Code Organization

- **main_fed_consensus_distance.py** generates the result of average consensus distance across layers for ResNet-20 and specified data-set.
The configuration of the experiment can be set at the beginning of the **main_fed_consensus_distance.py** as shown in the following:
```python
###############config_variables###############
config_file_name = '5'
num_of_node = int(config_file_name)
sampling_f = 100 #ms
iteration = 10 ** 4
repeat_simulation = 1
child_process = False
mps=True
gpu = 0
num_worker=5
batch_size=64
cte = True
# cte = [iteration//2,iteration*3//4,5]
lr_exp = list(range(4,5))
iid = False
identity = ["cifar10",0,0] # chose between "cifar10", "SVHN"
H=50
simulation_result_file_name = "simulation_result_consensus_distance" + config_file_name + "nodes_" + identity[0] +  "_iid" + str(iid) + "_H" +\
                              str(H) + "_iter" + str(iteration)
###############config_variables###############
```

- **config_file_name** identifies the numer of nodes in the network of the federated learning setting.
- Once you run **main_fed_consensus_distance.py** the simulation data will be saved at **result/simulation_result_file_name**.
- For the purpose of visualization use **visualization_difference.py** where you first set the config as follows.
```python
###############config_variables###############
data_file_name1 = 'result/fed_simulation_result_5nodes_cifar10_iidFalse_H50_alpha1'
data_file_name2 = 'result/fed_simulation_result_5nodes_cifar10_iidTrue_H50_alpha1'
final_figure_name = "consensus_error_across_layers"
###############config_variables###############
```
Here you can input multiple files to see the result.

Finally the figure will be saved at **figures/final_figure_name.pdf**.

- **main_fed_layer.py** generates the result of convergence behaviour and generalization (test accuracy) for ResNet-20 and specified data-set.
The configuration of the experiment can be set at the beginning of the **main_fed_layer.py** as shown in the following:

```python
###############config_variables###############
config_file_name = '1'
num_of_node = int(config_file_name)
sampling_f = 100 #ms
iteration = 10 ** 4
repeat_simulation = 1
child_process = False
mps=True
gpu = 0
num_worker=5
batch_size=64
cte = True
# cte = [iteration//2,iteration*3//4,5]
lr_exp = list(range(4,5))
iid = False
identity = ["cifar10",0,0] # chose between "cifar10", "SVHN"
H=50
alpha = 10
simulation_result_file_name = "simulation_result_consensus_distance" + config_file_name + "nodes_" + identity[0] +  "_iid" + str(iid) + "_H" +\
                              str(H) + "_alpha" + str(alpha) + "_iter" + str(iteration)
###############config_variables###############
```

- Once you run **main_fed_layer.py** the simulation data will be saved at **result/simulation_result_file_name**.
- For the purpose of visualization use **visualization.py** where you first set the config as follows.

```python
###############config_variables###############
data_file_name1 = 'result/simulation_result_5nodes_cifar100_iidFalse_H50_alpha1_iter10000_batch_size64'
data_file_name2 = 'result/simulation_result_5nodes_cifar100_iidFalse_H50_alpha10_iter10000_batch_size64'
data_file_name3 = 'result/scaffold_simulation_result_5nodes_cifar100_iidFalse_H50_alpha1_iter20000_batch_size64'
data_file_name4 = 'result/scaffold_simulation_result_5nodes_cifar100_iidFalse_H50_alpha10_iter20000_batch_size64'
final_figure_name = "iidFalse_cifar10_scaffold"
iteration =   10 **4
frequency = 100
###############config_variables###############
```
Finally the figure will be saved at **figures/final_figure_name.pdf**.
