import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np

sns.set_style("whitegrid")

hpn_dir = "/home/wangdongzi/extra2/pp/comix_hpn.csv"
comix_dir = "/home/wangdongzi/extra2/pp/comix.csv"
dimenet_dir = "/home/wangdongzi/extra2/pp/comix_dimenet.csv"

hpn_data = pd.read_csv(hpn_dir).values[:,:2]
comix_data = pd.read_csv(comix_dir).values[:,:2]
dimenet_data = pd.read_csv(dimenet_dir).values[:,:2]

length = 300
sns.lineplot(x=hpn_data[:length,0],y=hpn_data[:length,1],label="comix_hpn")
sns.lineplot(x=comix_data[:length,0],y=comix_data[:length,1],label="comix")
sns.lineplot(x=dimenet_data[:length,0],y=dimenet_data[:length,1],label="comix_dimenet(ours)")

plt.title("predator-prey")
plt.xlabel("step")
plt.ylabel("return")
plt.savefig("comix_vs_hpn_vs_dimenet22.pdf", dpi=400)

print("ok")