from .base import Base
from .gst import GST
from .goat import GOAT
from .gdo import GDO

methods = ["GST", "GOAT", "GDO"]

def get_method(method_name, model):
    if method_name.upper() not in methods:
        raise ValueError(f"Method {method_name} not supported. Supported methods: {methods}")
    return globals()[method_name.upper()](model)

__all__ = ["get_method", "methods"]
