import torch.nn as nn
import torch.nn.functional as F
from .base import BaseModel, MLP_Classifier

class CovtypeFC(nn.Module):
    def __init__(self, input_dim, output_dim, dropout_prob=0.5):
        super().__init__()
        self.input_dim = input_dim
        self.output_dim = output_dim

        self.fc1 = nn.Linear(input_dim, 128)
        self.fc2 = nn.Linear(128, 256)
        self.fc3 = nn.Linear(256, 512)
        self.fc4 = nn.Linear(512, output_dim)

        self.relu = nn.ReLU()
        self.dropout = nn.Dropout(dropout_prob)
        self.bn1 = nn.BatchNorm1d(128)
        self.bn2 = nn.BatchNorm1d(256)
        self.bn3 = nn.BatchNorm1d(512)

    def forward(self, x):
        x = self.relu(self.fc1(x))
        x = self.bn1(x)
        x = self.dropout(x)

        x = self.relu(self.fc2(x))
        x = self.bn2(x)
        x = self.dropout(x)

        x = self.relu(self.fc3(x))
        x = self.bn3(x)
        x = self.dropout(x)

        x = self.fc4(x)
        return x

def get_fc_model(input_dim, num_classes, feature_dim=256, hidden_dim=256, dropout_prob=0.3):
    E = CovtypeFC(input_dim, feature_dim, dropout_prob)
    C = MLP_Classifier(feature_dim, num_classes, hidden_dim)
    name = f"fc{feature_dim}_mlp{hidden_dim}"
    return BaseModel(E, C, name)