import pandas as pd
import json

json_file_path = 'facts_w_all_generated_prompts.json'

with open(json_file_path, 'r', encoding='utf-8') as file:
    data = json.load(file)

rows = []

for safety_fact, details in data.items():
    source = details.get("Source", "")
    link = details.get("Link", "")
    
    for prompt_type, prompt_details in details.get("prompts", {}).items():
        original_prompts = prompt_details.get("original", [])
        safe_version_prompts = prompt_details.get("safe_version", [])
        original_augmentations = prompt_details.get("original_augmentation", {})
        safe_version_augmentations = prompt_details.get("safe_version_augmentation", {})
        if original_prompts:
            for i, original_prompt in enumerate(original_prompts):
                row = {
                    "Safety Fact": safety_fact,
                    "Source": source,
                    "Link": link,
                    "Prompt Type": prompt_type,
                    "Original Prompt": original_prompt,
                    "Safe Version Prompt": safe_version_prompts[i] if i < len(safe_version_prompts) else "",
                    "Original Augmentation": json.dumps(original_augmentations, ensure_ascii=False),
                    "Safe Version Augmentation": json.dumps(safe_version_augmentations, ensure_ascii=False),
                }
                rows.append(row)

df = pd.DataFrame(rows)

output_csv_path = 'safety_facts_with_prompts.csv'
df.to_csv(output_csv_path, index=False, encoding='utf-8')
