import ast

def extract_list_from_code(code_string):
    """
    Extracts a list from a given Python code string.

    Args:
        code_string (str): A Python code string containing a list or list assignment.

    Returns:
        list: The extracted list from the code string.

    Raises:
        ValueError: If the code does not contain a valid list.
    """
    try:
        # Strip possible code block markers and whitespace
        code_string = code_string.strip('`').strip()

        # Remove language specifier if present
        if code_string.startswith("python"):
            code_string = code_string[len("python"):].strip()

        # If the code is directly a list, evaluate it safely
        if code_string.startswith('[') and code_string.endswith(']'):
            return ast.literal_eval(code_string)

        # Execute the code string in a restricted namespace if it is an assignment
        namespace = {}
        exec(code_string, {}, namespace)

        # Find the first variable that is a list in the namespace
        for key, value in namespace.items():
            if isinstance(value, list):
                return value

        raise ValueError("No list found in the provided code string.")
    except Exception as e:
        # print(code_string)
        raise ValueError(f"Invalid code string: {e}")
    
    
def extract_dict_from_string(string):
    """
    Extracts a dictionary from a Python string containing it.

    Args:
        string (str): The input string containing the dictionary.

    Returns:
        dict: The extracted dictionary.
    """
    try:
        # Find the part of the string that starts and ends with curly braces
        start = string.find('{')
        end = string.rfind('}') + 1
        dict_string = string[start:end]

        # Safely evaluate the dictionary string into a Python dictionary
        extracted_dict = ast.literal_eval(dict_string)
        return extracted_dict
    except Exception as e:
        print(f"Error extracting dictionary: {e}")
        return None