# Instructions on getting frequency count using WIMBD

## Step 1: Clone the WIMBD repo
```
git clone https://github.com/allenai/wimbd.git
```

## Step 2: Create a virtual environment for this repo
```
conda create -n wimbd python=3.9
conda activate wimbd

# or 
python3.9 -m venv wimbd
source wimbd/bin/activate



## Step 3: Install dependencies.
```
cd wimbd

# you can just do:
pip install -r requirements.txt
export PYTHONPATH="${PYTHONPATH}:/PATH/TO/wimbd/"

## Step 4: request index api keys from AI2.

## Step 5: Run unique_frac_with_wimbd.py

## (Optional) Create a jupyter notebook kernel using the new venv
```
pip install ipykernel
python -m ipykernel install --user --name=wimbd_venv --display-name="wimbd_kernel"
```
When running the notebook, you can then select this "wimbd_kernel" kernel to make sure the environment is aligned. 
