function [ r ] = GetR( B,gamma )
% This function can compute the radial coordinate of all nodes.
% B is the adjacent matrix of the target network;
% gamma is the power exponent of the target network;
    d=full(sum(B));
   % [dgr,order]=sort(d);
   [dgr,order]=radixsort(d);% The sorting algorithm is radix sort.
    dgr=fliplr(dgr);
    order=fliplr(order);
    n=length(dgr);
   
    beta=1/(gamma-1);  
    x=2*log(n);
    y=1:n;
    r=beta*2*log(y)+(1-beta)*x;
    r(order)=r;
end

