function [ theta_com ] = InitCoord_1( B,label,order )
%  assigne angular coordinates to the nodes in the network
%   Detailed explanation goes here
    theta_com=linspace(0,0,length(label)); 
    lab=unique(label);
    v=length(lab);
    d=full(sum(B));
    k=0;     
    for i=1:v
        t=d(find(label==lab(i)));
        k(i)=sum(t);
    end
    K=sum(k);
    bound=0;
  %  The angular coordinates of the nodes belonging to community i are sampled uniformly at random from corresponding angular sectors
    for i=1:v
        bound(i+1)=2*pi*k(order(i))/K+bound(i);
        x=find(label==lab(order(i)));
        theta_com(x)=(bound(i+1)-bound(i))*rand(1,length(x))+bound(i); 
    end

end

