function [ order1 ] = LocNextOrder( B,label,label1,order )
%--order communities in the lower level
    %--Firstly determine the internal order of the sub-community sets,then based on the internal ordered sub-communityies sets,
    %  determine the external order between the sub-community sets
    n=length(order);
    m=length(unique(label1));
    order1=linspace(0,0,m);
    sign=0;
    num=0;
    %--determine the internal order of the sub-community sets in turn(according to the community order of the upper-level)
    for i=1:n
        temp=NextCom( B,label,label1,order,i );
        lent=length(temp);
        order1((sign+1):(sign+lent))=temp;
        num(i)=lent;
        sign=sign+lent;
    end
    %--determine the external order, begin from the largest-size community
    lab=unique(label);
    sumd=0;
    for i=1:n
        sumd(i)=length(find(label==lab(i)));
    end
    [a,b]=max(sumd);
    %--determine the external order in three cases
    if b==1  % If the first community in [order] is the largest one, determine the external order toward right in turn
        orderk=order1(1:num(1));
        p=num(1);
        for i=2:n
            ordert=order1((p+1):(p+num(i)));
            [ ordert1 ] = ConnectNextCom( B,label1,(i-1),i,orderk,ordert );
            order1((p+1):(p+num(i)))=ordert1;
            orderk=ordert1;
            p=p+num(i);
        end
    end
    if b==n  %If the last community in [order] is the largest one,determine the external order toward left in turn
        p=sum(num(1:(n-1)));
        orderk=order1((p+1):m);
        for i=1:(n-1)
            j=n-i;
            ordert=order1(p-num(i)+1:p);
            [ ordert1 ] = ConnectNextCom( B,label1,(j+1),j,orderk,ordert );
            order1(p-num(i)+1:p)=ordert1;
            orderk=ordert1;
            p=p-num(j);
        end
    end
    if b>1 & b<n % first determine the external order toward left in turn,then toward right in turn
        p=sum(num(1:b-1));
        orderk=order1(p+1:p+num(b));
        for i=1:b-1  
            j=b-i;
            ordert=order1(p-num(j)+1:p);
            [ ordert1 ] = ConnectNextCom( B,label1,(j+1),j,orderk,ordert );
            order1(p-num(j)+1:p)=ordert1;
            orderk=ordert1;
            p=p-num(j);
        end
        p=sum(num(1:b-1));
        orderk=order1(p+1:p+num(b));
        p=p+num(b);
        for i=b+1:n  
            ordert=order1(p+1:p+num(i));
            [ ordert1 ] = ConnectNextCom( B,label1,(i-1),i,orderk,ordert );
            order1((p+1):(p+num(i)))=ordert1;
            orderk=ordert1;
            p=p+num(i);
        end
    end
    if length(unique(order1))~=m
         fprintf('Error!!! unique(order1)!=m !!\n')
    end
end

