
library(igraph)

g <- read_graph("data-for-louvain.txt", directed = F)

q <- cluster_louvain(g, weights = NULL, resolution = 1)

write.table(q$memberships, "communities.txt", sep=" ", col.names = FALSE, row.names = FALSE)

gamma <- fit_power_law(degree(g))$alpha

write.table(gamma, "gamma.txt", col.names = FALSE, row.names = FALSE)
