function [theta,r] = main_LPCS(A,label,label1,label2)
%   The function aims to mapping networks into hyperbolic space by using LPCS

%   If the total levels of the hierarchy is 3, then there are three label vectors.
%   Each vector represents the set of the community label each node belonging to.
%   The size of the vector is N. The number of the nodes in network is N.
%  If the community hierarchy is larger than 3, you can expand the input parameters.

%   input parameters:A--the adjacency matrix of the network
%                    label--the label vector of the top level
%                    label1--the label vector of the second level
%                    label2--the label vector of the bottom level

%   output parameters:theta--a vector containing the angular coordinates of all the nodes
%                     r--a vector containing the radial coordinates of all the nodes

% w is a matrix containing the number of connections between top-level communites
% w[i,i] represents the number of edges in community i(two endpoints of an edge are all in community i)
% w[i,j] represents the number of edges between community i and j.(one endpoint is in community i,the other one is in community j)
  [ Q,w ] = CalQ( A,label );
% order the top-level communities based on CI index
  order=LocOrder2(w); 
% order the second-level communites
 [ order1 ] = LocNextOrder( A,label,label1,order );
% order the bottom-level communites
  [ order2 ] = LocNextOrder( A,label1,label2,order1 );
%  assigne angular coordinates to all the nodes in the network. The angular coordinates of the nodes belonging to each community (in the
% bottom level) are sampled uniformly at random from corresponding angular sectors
 theta=InitCoord_1(A,label2,order2);
%  assigne radial coordiantes to all the nodes
 r=GetR( A,gama );
end