println("starting TreeRep experiment")
println("libraries")

# usage: julia -t 8 experiment.jl <graph CSV filename> <file to list labels> <file to list distances 1> <file to list distances 2>

using LightGraphs, SparseArrays, SimpleWeightedGraphs
using Statistics, BenchmarkTools, LinearAlgebra, ProgressMeter
using Base.Threads, PhyloNetworks, StatsBase, Distributions
using Base.GC, JLD2, FileIO, CSV, DataFrames
using Random, NPZ, GraphRecipes, Plots, Laplacians

if "SEED" in keys(ENV)
  Random.seed!(420 + parse(Int64, ENV["SEED"]))
else
  Random.seed!(42)
end

println("including")

include("src/TreeRep.jl")
include("src/ConstructTree.jl")
include("src/LevelTree.jl")
include("src/NJ.jl")
include("src/Utilities.jl")
include("src/Visualize.jl")
include("src/TreeOpt.jl")
include("src/SparseRep.jl")
include("src/Bartal.jl")

utilities.tm()

X = CSV.read(ARGS[1], DataFrame);

name_to_node_idx = Dict()
next_node = 1
G = SimpleGraph()
m,_ = size(X)

labels = Vector{String}()

for i = 1:m
    global next_node
    src = X[i,1]
    dst = X[i,2]
    if !haskey(name_to_node_idx,src)
        name_to_node_idx[src] = next_node
        next_node += 1
        push!(labels, string(src))
        add_vertex!(G)
    end
    
    if !haskey(name_to_node_idx,dst)
        name_to_node_idx[dst] = next_node
        next_node += 1
        push!(labels, string(dst))
        add_vertex!(G)
    end
    
    u = name_to_node_idx[src]
    v = name_to_node_idx[dst]
    add_edge!(G,u,v)
end

open(ARGS[2], "w") do file
    for l in labels
      write(file, l, "\n")
    end
end

n = nv(G)
W = adjacency_matrix(G);

n = nv(G)
E = ne(G)
@show((n,E));
@show(is_connected(G));

tdp = @elapsed D = utilities.parallel_dp_shortest_paths(G,adjacency_matrix(G))
println()
println("time elapsed of parallel_dp_shortest_paths = ", tdp)

D

t = @elapsed G2,W2 = TreeRep.metric_to_structure_no_recursion(D,undef,undef)
println()
println("time elapsed of metric_to_stucture_no_recursion = ", t)

G2 = utilities.remove_loops(G2)
flush(stdout)
B = W2[1:nv(G2),1:nv(G2)];
B = sparse(B);
B = (B .> 0) .* B;

GC.gc()
D2 = utilities.parallel_dp_shortest_paths(G2, B);
distort = utilities.avg_distortion(D2[1:n,1:n],D)
map2 = utilities.MAP(D2[1:n,1:n],G)

println()
println("norec distort = ", distort)
println("norec mAP = ", map2)

open(ARGS[3], "w") do file
    for i in 1:n
      for j in 1:i-1
        write(file, string(D2[i,j]), "\n")
      end
    end
end

t = @elapsed G2,W2 = TreeRep.metric_to_structure(D,undef,undef)
println()
println("time elapsed of metric_to_stucture = ", t)

G2 = utilities.remove_loops(G2)
flush(stdout)
B = W2[1:nv(G2),1:nv(G2)];
B = sparse(B);
B = (B .> 0) .* B;

GC.gc()
D2 = utilities.parallel_dp_shortest_paths(G2, B);
distort = utilities.avg_distortion(D2[1:n,1:n],D)
map2 = utilities.MAP(D2[1:n,1:n],G)

println()
println("wrec distort = ", distort)
println("wrec mAP = ", map2)

open(ARGS[4], "w") do file
    for i in 1:n
      for j in 1:i-1
        write(file, string(D2[i,j]), "\n")
      end
    end
end
