import networkx as nx
import sys
import hypCLOVE.hypCLOVE as clove
import math

name = sys.argv[1]

G = nx.read_edgelist(name)

emb = clove.embed(G, return_cartesian = False, seed = int(sys.argv[2]))

b = 1./(clove.fit_degree_decay_exponent(G = G, min_samples = None) - 1)

print("n R b T")
print(len(emb['coords']), "0", b, "0")

for key, coord in emb['coords'].items():
  print(key,coord[0],coord[1]*180/math.pi)



