#!/bin/bash

file_edges=$1
file_bfkl=$2
seed=25062025

if [ -n "$4" ]
then seed=-"$4"0
# KVK embedder requires a negative number -- otherwise it assumes seed -1
# added 0 so that SEED 1 is different than no SEED
fi

alpha=`head -n 2 <${file_bfkl} | tail -n 1 | awk '{print $3}'`;
temp=`head -n 2 <${file_bfkl} | tail -n 1 | awk '{print $4}'`;
gamma=`awk -v a="$alpha" 'BEGIN {print 2*a+1}'`;

echo alpha=$alpha temp=$temp gamma=$gamma seed=$seed

kvk/hyperlink.exe $file_edges $gamma $temp $seed $3 0 20 1;
rm /tmp/*_tmp_gcc*
