set.seed(30121706)

library(boot)

avgsample <- function(data, indices) {
  mean(data[indices]) 
}

bootfun <- function(data, formula) {
  bootstrap <- boot(data, formula, R=10000)
  bootstrap
  boot.ci(boot.out = bootstrap, type= c("norm", "bca"))
}

args <- commandArgs(trailingOnly = T)
m <- read.table(args[1], sep=";", as.is=T, header=T)

graphcats_list <- unique(m$graphcat)

result <- data.frame()

for (gc in graphcats_list) {
  a <- subset(m, m$graphcat == gc)
  
  xavg <- mean(a$val)
  varx <- var(a$val)
  
  print(gc)
  
  if (varx == 0 ) {
     bca_low <- xavg
     bca_high <- xavg
  } else {
    s <- bootfun(a$val, avgsample)
    bca_low <- s$bca[,4]
    bca_high <- s$bca[,5]
  }
  
  placeholder = data.frame(gc, xavg, bca_low, bca_high)
  
  result <- rbind(result, placeholder)
  }

write.table(result, args[2], sep = " ", row.names = F, col.names = F)
