#!/bin/bash

if [[ $1 == *b* ]]
then echo reembedding BFKL...
for x in graphs/simulated/*/*/graph.txt; do echo -n $x =; /usr/bin/time 2>&1 hyperbolic-embedder/embedder >/dev/null -seed 123456 -input $x -embed /tmp/result; done > tables/reembed-time-bfkl.txt
fi

if [[ $1 == *c* ]]
then echo reembedding Clove...
for x in graphs/simulated/*/*/graph.txt; do echo -n $x =; /usr/bin/time 2>&1  python hypCLOVE/import_clove.py $x 1 > /dev/null; done > tables/reembed-time-clove.txt
fi

if [[ $1 == *p* ]]
then echo creating precise-times.csv
echo "method;graph;ssize;stemp;sid;time" > tables/precise-times.csv
cat tables/reembed-time-bfkl.txt | grep -v inputs | sed "s:graphs/:bfkl;:" | sed "s:user.*$::" | sed "s:/graph.txt =:;:" | sed "s:/:;:g" | sed "s:-T:;:" >> tables/precise-times.csv
cat tables/reembed-time-clove.txt | grep -v inputs | sed "s:graphs/:clove;:" | sed "s:user.*$::" | sed "s:/graph.txt =:;:" | sed "s:/:;:g" | sed "s:-T:;:" >> tables/precise-times.csv
fi
