#!/bin/bash
# download hierarchies from WordNet and convert them

cd poincare-embeddings/wordnet
python transitive_closure.py
python transitive_closure_verb.py
cd ../..

for x in noun mammal verb
do echo converting $x
  DIR=graphs/$x
  mkdir -p $DIR
  cp poincare-embeddings/wordnet/"$x"_closure.csv graphs/$x/graph.csv
  # note: BFKL does not accept '/' in node names, we need to replace '/' with something else
  cat $DIR/graph.csv | sed -e "s:/:_:g" | grep -v "id1,id2" | sed -e "s/,1$//" | sed -e "s/,/ /" > $DIR/graph.txt
done

mkdir -p graphs/verbf
cp graphs/verb/graph.txt graphs/verbf/graph.txt
cp graphs/verb/graph.csv graphs/verbf/graph.csv
cat graphs/verb/graph.txt | tail +2 | tr " " "\n" | sort | uniq | sed "s/^\(.*\)$/\1 TOP/" >> graphs/verbf/graph.txt
cat graphs/verb/graph.txt | tail +2 | tr " " "\n" | sort | uniq | sed "s/^\(.*\)$/\1,TOP,1/" >> graphs/verbf/graph.csv

# also create other hierarchies

g++ scripts/convert-hierarchy.cpp -O3 -o bin/convert-hierarchy
for x in csphd
do echo converting $x
bin/convert-hierarchy graphs/$x/graph-orig.txt graphs/$x/graph.txt graphs/$x/graph.csv
done
rm bin/convert-hierarchy

function txttocsv {
  DIR=graphs/$1
  echo id1,id2,weight > $DIR/graph.csv
  cat $DIR/graph.txt | sed -e "s/$/,1/" | sed -e "s/ /,/" >> $DIR/graph.csv
  }

txttocsv acm
txttocsv mesh
txttocsv tetrapoda
