#include <vector>
#include <map>
#include <string>
#include <set>
#include <algorithm>
#include <cmath>

using namespace std;

vector<string> ids = {};

map<string, int> its;

vector<pair<int, int>> edges;

vector<vector<int>> edges_of;

int N;

int id_of(string s) {
  if(its.count(s)) return its[s];
  ids.push_back(s);
  return its[s] = N++;
  }

vector<int> current_comms;

map<int, map<int, int>> get_earray(const vector<pair<int, int>>& local_edges, const map<int, int>& coms) {
  map<int, map<int, int> > earray;
  for(auto e: local_edges)
    earray[coms.at(e.first)][coms.at(e.second)]++;

  return earray;
  }

vector<int> loc_order2(vector<pair<int, int>>& local_edges, const map<int, int>& coms) {
  auto earray = get_earray(local_edges, coms);

  map<int, int> sizes;
  for(auto [k, x]: coms) sizes[x]++;
  // printf("loc_order2 on %d\n", sizes.size());

  if(sizes.size() == 1) for(auto& [x, s]: sizes) return { x };

  int largest = sizes.begin()->first;
  for(auto& [x, s]: sizes) if(s > sizes[largest]) largest = x;

  auto ci = [&] (int i, int j) {
   return earray[i][j] * 1. / earray[i][i] + earray[i][j] * 1. / earray[j][j];
   };

  double second_largest_ci = -1;
  int second_largest = 0;
  for(auto& [x, s]: sizes) if(x != largest) {
    auto y = ci(x, largest);
    if(y > second_largest_ci) second_largest_ci = y, second_largest = x;
    }

  vector<int> order = { largest, second_largest };

  set<int> remain;
  for(auto& [x, s]: sizes) remain.insert(x);
  remain.erase(largest);
  remain.erase(second_largest);

  // printf("%d %d\n", largest, second_largest);
  while(remain.size()) {
    auto best = 0, ncomm = -1;
    for(auto x: remain) {
      auto curr = max(ci(x, order[0]), ci(x, order.back()));
      if(curr > best) best = curr, ncomm = x;
      }
    if(best) {
      auto x = ncomm;
      if(ci(x, order.back()) > ci(x, order[0])) order.push_back(x);
      else order.insert(order.begin(), x);
      remain.erase(x);
      continue;
      }
    break;
    }

  for(auto x: remain) {
    int best = 0, bpos = 0;
    for(int i=0; i<int(order.size()); i++) {
      auto curr = ci(x, order[i]);
      if(curr > best) best = curr, bpos = i;
      }
    order.insert(order.begin() + bpos + 1, x);
    }

  // printf("done\n");
  return order;
  }

map<int, int> vtm(const vector<int>& coms) {
  map<int, int> coms1;
  int idx = 0;
  for(auto p: coms) coms1[idx++] = p;
  return coms1;
  }

struct community_info {
  vector<pair<int, int>> local_e;
  vector<int> extorder;
  map<int, int> sublist;
  };

int main(int argc, char **argv) {

  int seed = 1;

  if(argc > 1) seed = atoi(argv[1]);

  char buf1[200], buf2[200];
  while(scanf("%s%s", buf1, buf2) == 2) {
    edges.emplace_back(id_of(buf1), id_of(buf2));
    }

  FILE *f = fopen("data-for-louvain.txt", "wt");
  for(auto [a, b]: edges) fprintf(f, "%d %d\n", a, b);
  fclose(f);

  f = fopen("louvain-seeded.R", "wt");
  fprintf(f, "set.seed(%d)\n", seed);
  fprintf(f, "source(\"louvain-community.R\")\n", seed);
  fclose(f);

  system("R --no-save < louvain-seeded.R > /dev/null");

  vector<vector<int>> data;

  f = fopen("communities.txt", "rt");
  while(!feof(f)) {
    data.emplace_back();
    data.back().resize(N);
    for(int i=0; i<N; i++) fscanf(f, "%d", &data.back()[i]);
    }
  data.pop_back();
  fflush(stdout);
  fclose(f);

  auto last = data.back();

  auto order = loc_order2(edges, vtm(last)); data.pop_back();

  // printf("after first\n");
  
  int total = 0;

  while(!data.empty()) {
    auto next = data.back(); data.pop_back();

    map<int, community_info> subs;

    auto next_earray = get_earray(edges, vtm(next));

    auto ci = [&] (int i, int j) {
     return next_earray[i][j] * (1. / next_earray[i][i] + 1. / next_earray[j][j]);
     };

    for(int i=0; i<N; i++) subs[last[i]].sublist[i] = next[i];

    for(auto [v, w]: edges) if(last[v] == last[w]) subs[last[v]].local_e.emplace_back(v, w);

    for(auto& [id, s]: subs) s.extorder = loc_order2(s.local_e, s.sublist);

    /* for(auto& [id, s]: subs) {
      printf("id = %d sublist size = %d extorder = %d\n", id, int(s.sublist.size()), int(s.extorder.size()));
      for(auto e: s.extorder) printf("%d ", e); printf("\n");
      } */

    int OldN = order.size();

    int largest_index = 0;
    for(int i=0; i<OldN; i++)
      if(subs[order[i]].extorder.size() > subs[order[largest_index]].extorder.size())
        largest_index = i;

    // printf("largest_index = %d/%d\n", largest_index, OldN);

    for(int i=largest_index + 1; i < OldN; i++) {
      if(ci(subs[order[i-1]].extorder.back(), subs[order[i]].extorder.back()) > ci(subs[order[i-1]].extorder.back(), subs[order[i]].extorder[0]))
        reverse(subs[order[i]].extorder.begin(), subs[order[i]].extorder.end());
      }

    for(int i=largest_index - 1; i >= 0; i--) {
      if(ci(subs[order[i+1]].extorder[0], subs[order[i]].extorder[0]) > ci(subs[order[i+1]].extorder[0], subs[order[i]].extorder.back()))
        reverse(subs[order[i]].extorder.begin(), subs[order[i]].extorder.end());
      }

    vector<int> order2;
    for(auto a: order) {
      // printf("[%d:", a); for(auto x: subs[a].extorder) printf(" %d", x); printf("] ");
      for(auto x: subs[a].extorder) order2.push_back(x);
      }
    // printf("\n");

    last = next; order = order2;
    }

  map<int, int> comsize;
  for(auto a: last) comsize[a]++;

  int sofar = 0;
  map<int, int> cumulative;
  for(auto a: order) { cumulative[a] = sofar; sofar += comsize[a]; }

  srand(seed);

  vector<int> degs(N, 0);
  for(auto [u, v]: edges) degs[u]++, degs[v]++;

  vector<int> dorder(N);
  for(int i=0; i<N; i++) dorder[i] = i;
  sort(dorder.begin(), dorder.end(), [&] (int i, int j) { return degs[i] > degs[j]; });

  f = fopen("gamma.txt", "rt");
  double gamma;
  fscanf(f, "%lf", &gamma);
  fclose(f);

  double beta = 1 / (gamma-1);  

  printf("n R gamma T\n%d 0 %lf 0\n", N, gamma);
  int index = 0;
  for(auto o: dorder) {
    index++;
    double r = beta*2*log(index)+(1-beta)*2*log(N);
    double theta = (rand() % 1000000 + .5) / 1000000;
    theta = theta * comsize[last[o]] + cumulative[last[o]];
    theta /= N;
    theta *= 360;
    printf("%s %.20lf %.20lf\n", ids[o].c_str(), r, theta);
    }

  return 0;
  }
