m <- read.table("../tables/statistical-data.csv", sep=";", as.is=T, header=T)
table(m$graph)

# for convenient visualizations make quality measures to [0,1], the higher the better

m$success <- as.numeric(m$success)
m$mAP <- as.numeric(m$mAP)
m$meanrank <- as.numeric(m$meanrank)
m$stretch <- as.numeric(m$stretch)

# inv_meanrank <- 1 / meanrank ; inv_stretch <- 1/stretch
m$invmr <- 1/m$meanrank
m$invstr <- 1/m$stretch

sim <- subset(m, graph=="simulated")

table(sim$method)

# table with real graphs
q <- subset(m, graph!="simulated")
q <- subset(q, graph!="sim3")

q <- subset(q, q$sid==0)
q <- unique(q)

q$graph <- as.factor(q$graph)
q <- subset(q, graph!="mammal")

q$graph <- factor(q$graph, levels = c("acm", "csphd", "mesh", "noun", "tetrapoda", "verbf",
                                      "astroph", "condmat", "grqc", "hepph", "diseasome", "facebook", 
                                      "followers-2009", "yeast", "openflights", "ias",
                                      "connectome/Cat1", "connectome/Cat2", "connectome/Cat3",
                                      "connectome/CElegans", "connectome/Drosophila1", "connectome/Drosophila2",
                                      "connectome/Human1", "connectome/Human2", "connectome/Human6",
                                      "connectome/Human7", "connectome/Human8", "connectome/Macaque1", "connectome/Macaque2",
                                      "connectome/Macaque3", "connectome/Macaque4", "connectome/Mouse2", "connectome/Mouse3",
                                      "connectome/Rat1", "connectome/Rat2", "connectome/Rat3", "connectome/ZebraFinch2"))

# exclude experimental unpublished embedders and discrete variants
q <- subset(q, q$name != "X")
q <- subset(q, q$name != "HypCLOVE+DHRG")
q <- subset(q, q$name != "Lorentz2D+DHRG")
q <- subset(q, q$name != "Poincare2D+DHRG")
q <- subset(q, q$name != "RogueViz")

library(tidyverse)

draw_best_rankings <- function(filename, df, measure, anim_var, shape_vector, color_vector, title, jitter) {
  library(ggplot2)
  pdf(filename, 15,8)
  if (jitter == F) {
    g <- ggplot(df, aes_string(x=anim_var, y=measure)) +
      geom_point(aes(shape=name, color=name), size=3) + 
      scale_shape_manual(values=shape_vector) +
      scale_color_manual(values=color_vector) +
      xlab("graph") + ylab(title) +
      scale_x_discrete(guide = guide_axis(angle = 90)) + theme_minimal(base_size = 15) +
      guides(shape = guide_legend(ncol = 1)) 
  } else {
    g <- ggplot(df, aes_string(x=anim_var, y=measure)) +
      geom_point(aes(shape=name, color=name), position = position_jitterdodge(0, dodge.width = .2), size=3) + 
      scale_shape_manual(values=shape_vector) +
      scale_color_manual(values=color_vector) +
      xlab("graph") + ylab(title) +
      scale_x_discrete(guide = guide_axis(angle = 90)) + theme_minimal(base_size = 15) +
      guides(shape = guide_legend(ncol = 1))
  }
  
  print(g)
  dev.off() 
}

prepare_ranking <- function(df, df_orig, graph_list, measure) {
  for (graph1 in graph_list) {
    a <- subset(df_orig, df_orig$graph==graph1)
    
    placeholder = data.frame(matrix(nrow = nrow(a), ncol = 3)) 
    colnames(placeholder) = c("name","graph","rank") 
    placeholder$name <- a$name
    placeholder$graph <- a$graph
    placeholder$rank <-  rank(a[[measure]], na.last = "keep")
    
    df <- rbind(df, placeholder)
  }
  return(df)
}


tab <- rbind(
  c("BFKL", 0, "black"),
  c("BFKL+DHRG", 12, "black"),
  c("Penalty", 7, "black"),
  c("Lorentz2D", 5, "black"),
  c("Lorentz3D", 5, "forestgreen"),
  c("Poincare2D", 2, "black"),
  c("Poincare3D", 2, "forestgreen"),
  c("Poincare5D", 2, "blue"),
  c("Mercator fast", 1, "black"),
  c("Mercator full", 13, "black"),
  c("d-Mercator", 13, "forestgreen"),
  c("Anneal2D", 6, "black"),
  c("Anneal3D",6 , "forestgreen"),
  c("LTiling",3, "black"),
  c("TreeRep", 4, "darkred"),
  c("Euclidean200D",3, "blue"),
  c("Euclidean50D", 4, "blue"),
  c("Coalescent2",10, "black"),
  c("Coalescent3",10, "forestgreen"),
  c("KVK", 11, "black"),
  c("HypCLOVE", 8, "black"),
  c("LPCS", 14, "black"),
  c("HypViewer", 9, "forestgreen")
)

#c("Lorentz2D+DHRG", 9, "black"),

q$name <- factor(q$name, levels = tab[,1])
#tab <- tab[order(tab[,1]),]

shapes <- as.numeric(t(tab) [2,])
colors <- t(tab) [3,]

graphs_full <- c("acm", "csphd", "mesh", "noun", "tetrapoda", "verbf",
                 "astroph", "condmat", "grqc", "hepph", "diseasome", "facebook", 
                 "followers-2009", "yeast", "openflights", "ias")

graphs_conn <- c("connectome/Cat1", "connectome/Cat2", "connectome/Cat3",
                 "connectome/CElegans", "connectome/Drosophila1", "connectome/Drosophila2",
                 "connectome/Human1", "connectome/Human2", "connectome/Human6",
                 "connectome/Human7", "connectome/Human8", "connectome/Macaque1", "connectome/Macaque2",
                 "connectome/Macaque3", "connectome/Macaque4", "connectome/Mouse2", "connectome/Mouse3",
                 "connectome/Rat1", "connectome/Rat2", "connectome/Rat3", "connectome/ZebraFinch2")

#to_exclude <- c("Euclidean200D", "Euclidean50D", "Poincare5D", "TreeRep", "LTiling")
to_exclude <- c()

tab2 <- tab[!(tab[,1] %in% to_exclude),]
shapes2 <- as.numeric(t(tab2) [2,])
colors2 <- t(tab2) [3,]

# plots for MAP

aux <- subset(q, graph %in% graphs_full)
draw_best_rankings("~/real-world_MAP.pdf", aux, "mAP", "graph", shapes, colors, "MAP", T)

ranking <- data.frame()
ranking <- prepare_ranking(ranking, q, graphs_full, "mAP")
draw_best_rankings("~/real-world_MAP_ranking.pdf", ranking, "rank", "graph", shapes, colors, "ranks of MAP", F)

aux <- subset(q, graph %in% graphs_conn)
aux <- subset(aux, !(name %in% to_exclude))
aux$graph <- gsub("connectome/", "", aux$graph)
draw_best_rankings("~/real-world_MAP_conn.pdf", aux, "mAP", "graph", shapes2, colors2, "MAP", T)

ranking <- data.frame()
aux <- subset(q, !(name %in% to_exclude))
ranking <- prepare_ranking(ranking, aux, graphs_conn, "mAP")
ranking$graph <- gsub("connectome/", "", ranking$graph)
draw_best_rankings("~/real-world_MAP_ranking_conn.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of MAP", F)

# for the needs of short version

graphs_paper <- c("acm", "csphd", "mesh", "noun", "tetrapoda", "verbf",
                  "astroph", "condmat", "grqc", "hepph", "diseasome", "facebook", "yeast",
                  "connectome/CElegans", "connectome/Human1", "connectome/Drosophila1", "connectome/Mouse3")
aux <- subset(q, graph %in% graphs_paper)
aux$graph <- gsub("connectome/", "", aux$graph)
draw_best_rankings("~/real-world_MAP_short.pdf", aux, "mAP", "graph", shapes, colors, "MAP",T)

# plots for MR
aux <- subset(q, graph %in% graphs_full)
draw_best_rankings("~/real-world_MR.pdf", aux, "invmr", "graph", shapes, colors, "IMR",T)

ranking <- data.frame()
ranking <- prepare_ranking(ranking, q, graphs_full, "invmr")
draw_best_rankings("~/real-world_MR_ranking.pdf", ranking, "rank", "graph", shapes, colors, "ranks of IMR",F)

aux <- subset(q, graph %in% graphs_conn)
aux <- subset(aux, !(name %in% to_exclude))
aux$graph <- gsub("connectome/", "", aux$graph)
draw_best_rankings("~/real-world_MR_conn.pdf", aux, "invmr", "graph", shapes2, colors2, "IMR",T)

ranking <- data.frame()
aux <- subset(q, !(name %in% to_exclude))
ranking <- prepare_ranking(ranking, aux, graphs_conn, "invmr")
ranking$graph <- gsub("connectome/", "", ranking$graph)
draw_best_rankings("~/real-world_MR_ranking_conn.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of IMR",F)


# plots for success

hierarchies <- c("noun", "verbf", "acm", "mesh", "tetrapoda", "csphd")
aux <- subset(q, !( graph  %in% hierarchies) & !(graph %in% graphs_conn) & !(name %in% to_exclude))

draw_best_rankings("~/real-world_success.pdf", aux, "success", "graph", shapes2, colors2, "Greedy success rate",T) 

ranking <- data.frame()
ranking <- prepare_ranking(ranking, aux, graphs_full, "success")
draw_best_rankings("~/real-world_success_ranking.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of greedy success",F)

aux <- subset(q, graph %in% graphs_conn & !(name %in% to_exclude))

aux$graph <- gsub("connectome/", "", aux$graph)
draw_best_rankings("~/real-world_success_conn.pdf", aux, "success", "graph", shapes2, colors2, "Greedy success rate",T)

aux <- subset(q, graph %in% graphs_conn)
aux <- subset(aux, !(name %in% to_exclude))
ranking <- data.frame()
ranking <- prepare_ranking(ranking, aux, graphs_conn, "success")
ranking$graph <- gsub("connectome/", "", ranking$graph)
draw_best_rankings("~/real-world_success_ranking_conn.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of greedy success",F)

# for paper
aux <- subset(q, graph %in% graphs_paper)
aux <- subset(aux, !( graph  %in% hierarchies))
aux <- subset(aux, !(name %in% to_exclude))
aux$graph <- gsub("connectome/", "", aux$graph)
draw_best_rankings("~/real-world_success_short.pdf", aux, "success", "graph", shapes2, colors2, "Greedy success rate",T)

# plots for stretch

aux <- subset(q, !( graph  %in% hierarchies) & !(graph %in% graphs_conn) & !(name %in% to_exclude))

draw_best_rankings("~/real-world_stretch.pdf", aux, "invstr", "graph", shapes2, colors2, "Stretch", T) 

ranking <- data.frame()
ranking <- prepare_ranking(ranking, aux, graphs_full, "invstr")
draw_best_rankings("~/real-world_stretch_ranking.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of stretch", F)

aux <- subset(q, graph %in% graphs_conn & !(name %in% to_exclude))

aux$graph <- gsub("connectome/", "", aux$graph)
draw_best_rankings("~/real-world_stretch_conn.pdf", aux, "invstr", "graph", shapes2, colors2, "Stretch", T)

aux <- subset(q, graph %in% graphs_conn)
aux <- subset(aux, !(name %in% to_exclude))
ranking <- data.frame()
ranking <- prepare_ranking(ranking, aux, graphs_conn, "invstr")
ranking$graph <- gsub("connectome/", "", ranking$graph)
draw_best_rankings("~/real-world_stretch_ranking_conn.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of stretch",F)

# plots for GRE
aux <- subset(q, !( graph  %in% hierarchies) & !(graph %in% graphs_conn) & !(name %in% to_exclude))

draw_best_rankings("~/real-world_gre.pdf", aux, "effect", "graph", shapes2, colors2, "Greedy Routing Efficiency",T) 

ranking <- data.frame()
ranking <- prepare_ranking(ranking, aux, graphs_full, "effect")
draw_best_rankings("~/real-world_gre_ranking.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of GRE",F)

aux <- subset(q, graph %in% graphs_conn & !(name %in% to_exclude))

aux$graph <- gsub("connectome/", "", aux$graph)
draw_best_rankings("~/real-world_gre_conn.pdf", aux, "effect", "graph", shapes2, colors2, "GRE",T)

aux <- subset(q, graph %in% graphs_conn)
aux <- subset(aux, !(name %in% to_exclude))
ranking <- data.frame()
ranking <- prepare_ranking(ranking, aux, graphs_conn, "effect")
ranking$graph <- gsub("connectome/", "", ranking$graph)
draw_best_rankings("~/real-world_gre_ranking_conn.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of GRE",F)


# plots for control
to_exclude <- c("Euclidean200D", "Euclidean50D", "Poincare5D", "TreeRep", "LTiling")

hierarchies <- c("noun", "verbf", "acm", "mesh", "tetrapoda", "csphd")
aux <- subset(q, !( graph  %in% hierarchies) & !(graph %in% graphs_conn) & !(name %in% to_exclude))

draw_best_rankings("~/real-world_control.pdf", aux, "control", "graph", shapes2, colors2, "ICV",T)

ranking <- data.frame()
ranking <- prepare_ranking(ranking, aux, graphs_full, "control")
draw_best_rankings("~/real-world_control_ranking.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of ICV",F)

aux <- subset(q, graph %in% graphs_conn)
aux <- subset(aux, !(name %in% to_exclude))
aux$graph <- gsub("connectome/", "", aux$graph)
draw_best_rankings("~/real-world_control_conn.pdf", aux, "control", "graph", shapes2, colors2, "ICV", T)

ranking <- data.frame()
aux <- subset(q, !(name %in% to_exclude))
ranking <- prepare_ranking(ranking, aux, graphs_conn, "control")
ranking$graph <- gsub("connectome/", "", ranking$graph)
draw_best_rankings("~/real-world_control_ranking_conn.pdf", ranking, "rank", "graph", shapes2, colors2, "ranks of ICV", F)
