#include <string>
#include <vector>
#include <iostream>
#include <map>

using namespace std;

vector<string> graphs;

map<string, map<string, double>> values;

int main(int argc, char ** argv) {

  string graph = "none";
  string s;

  while(getline(cin, s)) {
    int p = -1;
    for(int i=0; i<int(s.size()); i++) if(s[i] == '=') p = i;
    if(p == -1) continue;
    string cat = s.substr(0, p);
    string vals = s.substr(p+1);
    if(cat == "GRAPH") { graph = vals; graphs.push_back(graph); continue; }
    if(vals == "") continue;
    double vald = atof(vals.c_str());
    values[graph][cat] = vald;
    }

  printf("graph;ssize;stemp;sid;n;m;method;dim;discrete;mAP;meanrank;success;stretch;effect;msuccess;mstretch;meffect;time;radius;loglik;control;name\n");
  for(auto g: graphs) {
    char head[100];
    auto& v = values[g];
    if(g.substr(0, 12) == "simulated/3d") {
      int n, r, t, id;
      sscanf(g.c_str(), "simulated/3d/%d-%d-%d/%d", &n, &r, &t, &id);
      sprintf(head, "sim3;%d;%d%d;%d;%d;%d", n, r, t, id, int(v["n"]), int(v["m"]));
      }
    else if(g.substr(0, 9) == "simulated") {
      int n, t, id;
      sscanf(g.c_str(), "simulated/%d-T%d/%d", &n, &t, &id);
      sprintf(head, "simulated;%d;%d;%d;%d;%d", n, t, id, int(v["n"]), int(v["m"]));
      }
    else if(g[2] == '/') {
      auto g1 = g.substr(3);
      sprintf(head, "%s;;;%c;%d;%d", g1.c_str(), g[1], int(v["n"]), int(v["m"]));
      }
    else {
      sprintf(head, "%s;;;0;%d;%d", g.c_str(), int(v["n"]), int(v["m"]));
      }

    auto entropy = v["entropy"];

    auto line = [&] (const char* header, const string& prefix, const char *trailer, const string& prefix2="") {
      if(!v.count(prefix+"map") && !v.count(prefix+"greedy_stretch")) return;
      printf("%s;%s;", head, header);
      if(v.count(prefix+"map")) printf("%.6f;", v[prefix+"map"]); else printf(";");
      if(v.count(prefix+"meanrank")) printf("%.6f;", v[prefix+"meanrank"]); else printf(";");
      if(v.count(prefix+"greedy_success")) printf("%.6f;", v[prefix+"greedy_success"]); else printf(";");
      if(v.count(prefix+"greedy_stretch")) printf("%.6f;", v[prefix+"greedy_stretch"]); else printf(";");
      if(v.count(prefix+"greedy_effect")) printf("%.6f;", v[prefix+"greedy_effect"]); else printf(";");
      if(v.count(prefix+"modded_success")) printf("%.6f;", v[prefix+"modded_success"]); else printf(";");
      if(v.count(prefix+"modded_stretch")) printf("%.6f;", v[prefix+"modded_stretch"]); else printf(";");
      if(v.count(prefix+"modded_effect")) printf("%.6f;", v[prefix+"modded_effect"]); else printf(";");
      if(v.count(prefix+"time")) printf("%d;", int(v[prefix+"time"])); else printf(";");
      if(v.count(prefix+"au")) printf("%.2f;", (v[prefix+"au"])); else printf(";");
      if(entropy && v.count(prefix+"loglik")) printf("%.6f;", 1 - v[prefix+"loglik"] / entropy); else printf(";");
      if(entropy && v.count(prefix+"control")) printf("%.6f;", entropy / (entropy + v[prefix+"control"])); else printf(";");
      printf("%s\n", trailer);
      };
    
    line("bfkl;2;0", "bfkl_", "BFKL");
    line("bfkl;2;1", "bfkl_d", "X");
    line("bfkl;2;2", "bfkl_d", "X");
    line("bfkl;2;3", "bfkl_dhrg_", "BFKL+DHRG");
    line("bfkl;2;4", "bfkl_penalty2_", "Penalty");

    line("poincare;2;0", "poincare2_", "Poincare2D");
    line("poincare;3;0", "poincare3_", "Poincare3D");
    line("poincare;5;0", "poincare5_", "Poincare5D");
    line("poincare;2;3", "poincare2_dhrg_", "Poincare2D+DHRG");
    line("lorentz;2;0", "lorentz2_", "Lorentz2D");
    line("lorentz;2;1", "lorentz2_d", "X");
    line("lorentz;2;2", "lorentz2_d", "X");
    line("lorentz;2;3", "lorentz2_dhrg_", "Lorentz2D+DHRG");
    line("lorentz;3;0", "lorentz3_", "Lorentz3D");
    line("euclidean;50;0", "euclidean50_", "Euclidean50D");
    line("euclidean;200;0", "euclidean200_", "Euclidean200D");

    line("anneal;2;0", "anneal2_", "Anneal2D");
    line("anneal;3;0", "anneal3_", "Anneal3D");

    line("mercatorfast;2;0", "mfast_", "Mercator fast");
    line("mercatorfull;2;0", "mfull_", "Mercator full");
    line("mercator;3;0", "mdim_", "d-Mercator");

    line("treerep_norec;1;0", "norec_treerep_", "X");
    line("treerep_wrec;1;0", "wrec_treerep_", "TreeRep");
    line("ltiling;2;0", "ltiling_", "LTiling");

    line("coalescent;2;0", "coalescent2_", "Coalescent2");
    line("coalescent;3;0", "coalescent3_", "Coalescent3");
    line("kvk;2;0", "kvk_", "KVK", "kvk_");
    line("lpcs;2;0", "lpcs_", "LPCS", "lpcs_");

    line("clove;2;0", "clove_", "HypCLOVE", "clove_");
    line("clove;2;1", "clove_d", "X");
    line("clove;2;2", "clove_d", "X");
    line("clove;2;3", "clove_dhrg_", "HypCLOVE+DHRG");

    line("hypviewer;3;0", "hypviewer_", "HypViewer");
    line("rogueviz;2;0", "rogueviz_", "RogueViz");

    fflush(stdout);
    }

  return 0;
  }
