name=$1
shift

model=$1
shift

echo name is $name, model is $model

EXTRA=
if [ -f graphs/$name/notrans.txt ]
then EXTRA="-alt-edges ../graphs/$name/notrans.txt"
fi

DHRG="./hyper -c - -s - -fillmodel ffffffff -canvas i -stdgrid c0c0ffff -dftcolor c0ffc0ff -gridon -rvedge 808080ff -fore 0 -zoom .95 -wsh 9 -smart 20"
VIEW="-cview -run -rvlabelscale 0.5 -shot-1000 -shott 1 -svgshot ../visualizations/$name-$model.svg -exit"

DHRG3="./hyper -c - -s - -geo 534h -PM 0 -fillmodel ffffffff -canvas i -stdgrid c0c0ffff -dftcolor c0ffc0ff -rvedge 808080ff -fore 0 -zoom .95 -wsh 9 -smart 1"
DHRG3A="./hyper -c - -s - -geo 435h -bch-subcubes 2 -PM 0 -fillmodel ffffffff -canvas i -stdgrid c0c0ffff -dftcolor c0ffc0ff -rvedge 808080ff -fore 0 -zoom .95 -wsh 9 -smart 1"

RDIR=../results/$name
IDIR=../graphs/$name

cd hyperrogue
case $model in
  lorentz2) $DHRG $EXTRA -graphv $RDIR/lorentz2 -lab $VIEW ;;
  lorentz2d) $DHRG $EXTRA -eload $RDIR/lorentz2 -dhrgview -lab $VIEW ;;
  bfkl) $DHRG $EXTRA -graphv $RDIR/bfkl -lab $VIEW ;;
  bfkld) $DHRG $EXTRA -eload $RDIR/bfkl -dhrgview -lab $VIEW ;;
  mfast) $DHRG $EXTRA -graphv $RDIR/mercator-fast -lab $VIEW ;;
  mfull) $DHRG $EXTRA -graphv $RDIR/mercator-full -lab $VIEW ;;
  poincare2) $DHRG $EXTRA -graphv $RDIR/lorentz2 -rdi $IDIR/graph.txt -lab -run -viz-poincare $RDIR/poincare2.txt $VIEW ;;
  poincare3) $DHRG3 $EXTRA -graphv $RDIR/lorentz2 -rdi $IDIR/graph.txt -lab -run -viz-poincare $RDIR/poincare3.txt $VIEW ;;
  lorentz3) $DHRG3 $EXTRA -graphv $RDIR/lorentz2 -rdi $IDIR/graph.txt -lab -run -viz-lorentz $RDIR/lorentz3.txt $VIEW ;;
  mercator3) $DHRG3 $EXTRA -graphv $RDIR/lorentz2 -rdi $IDIR/graph.txt -lab -run -viz-mercator3 $RDIR/d-mercator.inf_coord $VIEW ;;
  anneal2)
    $DHRG $EXTRA -sag-creq 20000 -sag_gdist_load /tmp/graph-g711 -sagformat 1 -sag $IDIR/graph.txt -sag-load-solution <(cat $RDIR/log-anneal2-fulleval.txt | grep "solution" | tail -n 1 | sed "s/^.*(//" | sed "s/)//" | sed "s/,/ /g") -lab $VIEW ;;

  anneal3)
    $DHRG3A $EXTRA -sag-creq 20000 -sag_gdist_load /tmp/graph-g435b2 -sagformat 1 -sag $IDIR/graph.txt -sag-load-solution <(cat $RDIR/log-anneal3-fulleval.txt | grep "solution" | tail -n 1 | sed "s/^.*(//" | sed "s/)//" | sed "s/,/ /g") -lab $VIEW ;;

  esac
cd ..
